/*
 * Decompiled with CFR 0.152.
 */
package org.jonlin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import java.util.Vector;

public class WeatherMan
extends Frame {
    public static int checkInterval;
    public static int zipcode;
    public static int initialWidth;
    public static int initialHeight;
    public static int xOffset;
    public static int yOffset;
    public static int textXoffset;
    public static int textYoffset;
    public static boolean dontResize;
    public static boolean dontMerge;
    public static boolean scaleImage;
    public static boolean dontShowBig;
    public static boolean dontShowDetail;
    public static int bigWidth;
    public static int bigHeight;
    public static int bigXoffset;
    public static int bigYoffset;
    public static int detailWidth;
    public static int detailHeight;
    public static int detailXoffset;
    public static int detailYoffset;
    public static final String usMapSmall = "http://image.weather.com/images/maps/current/curwx_167x113.jpg";
    public static final String usMapLarge = "http://image.weather.com/images/maps/current/curwx_277x187.jpg";
    public static final String neMapSmall = "http://image.weather.com/images/maps/current/cur_ne_167x113.jpg";
    public static final String neMapLarge = "http://image.weather.com/images/maps/current/cur_ne_277x187.jpg";
    public static final String nwMapSmall = "http://image.weather.com/images/maps/current/cur_nw_167x113.jpg";
    public static final String nwMapLarge = "http://image.weather.com/images/maps/current/cur_nw_277x187.jpg";
    public static final String swMapSmall = "http://image.weather.com/images/maps/current/cur_sw_167x113.jpg";
    public static final String swMapLarge = "http://image.weather.com/images/maps/current/cur_sw_277x187.jpg";
    public static final String seMapSmall = "http://image.weather.com/images/maps/current/cur_se_167x113.jpg";
    public static final String seMapLarge = "http://image.weather.com/images/maps/current/cur_se_277x187.jpg";
    public static final String mwMapSmall = "http://image.weather.com/images/maps/current/cur_mw_167x113.jpg";
    public static final String mwMapLarge = "http://image.weather.com/images/maps/current/cur_mw_277x187.jpg";
    public static String currentImageURL;
    public static String currentBigImageURL;
    public static int fontSize;
    public static int fontAttrib;
    public static Color bg;
    public static Color fg;
    WeatherThread weatherThread;
    Image currentImage;
    Image currentBigImage;
    PicturePanel picture;
    TextPanel text;
    BigPicturePanel bigPicture;
    DetailedTextPanel detailText;

    public static void main(String[] stringArray) {
        currentImageURL = usMapSmall;
        currentBigImageURL = usMapLarge;
        fg = Color.white;
        bg = Color.black;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("-")) {
                    String string;
                    int n;
                    int n2;
                    if (stringArray[i].equals("-t")) {
                        checkInterval = Integer.parseInt(stringArray[++i].trim()) * 60000;
                        continue;
                    }
                    if (stringArray[i].equals("-x")) {
                        initialWidth = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-y")) {
                        initialHeight = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-off_x")) {
                        xOffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-off_y")) {
                        yOffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-rv")) {
                        fg = Color.black;
                        bg = Color.white;
                        continue;
                    }
                    if (stringArray[i].equals("-fg")) {
                        int n3 = Integer.parseInt(stringArray[++i].trim());
                        n2 = Integer.parseInt(stringArray[++i].trim());
                        n = Integer.parseInt(stringArray[++i].trim());
                        fg = new Color(n3, n2, n);
                        continue;
                    }
                    if (stringArray[i].equals("-bg")) {
                        int n4 = Integer.parseInt(stringArray[++i].trim());
                        n2 = Integer.parseInt(stringArray[++i].trim());
                        n = Integer.parseInt(stringArray[++i].trim());
                        bg = new Color(n4, n2, n);
                        continue;
                    }
                    if (stringArray[i].equals("-dontAutoResize")) {
                        dontResize = true;
                        continue;
                    }
                    if (stringArray[i].equals("-dontMerge")) {
                        dontMerge = true;
                        continue;
                    }
                    if (stringArray[i].equals("-scaleImage")) {
                        scaleImage = true;
                        continue;
                    }
                    if (stringArray[i].equals("-boldFont")) {
                        fontAttrib = 1;
                        continue;
                    }
                    if (stringArray[i].equals("-fontSize")) {
                        fontSize = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-showBigPicture")) {
                        dontShowBig = false;
                        continue;
                    }
                    if (stringArray[i].equals("-big_x")) {
                        bigWidth = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-big_y")) {
                        bigHeight = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-big_off_x")) {
                        bigXoffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-big_off_y")) {
                        bigYoffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-showDetails")) {
                        dontShowDetail = false;
                        continue;
                    }
                    if (stringArray[i].equals("-detail_x")) {
                        detailWidth = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-detail_y")) {
                        detailHeight = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-detail_off_x")) {
                        detailXoffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-detail_off_y")) {
                        detailYoffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-text_off_x")) {
                        textXoffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (stringArray[i].equals("-text_off_y")) {
                        textYoffset = Integer.parseInt(stringArray[++i].trim());
                        continue;
                    }
                    if (!stringArray[i].equals("-mapType")) continue;
                    if ((string = stringArray[++i]).equalsIgnoreCase("us")) {
                        currentImageURL = usMapSmall;
                        currentBigImageURL = usMapLarge;
                        continue;
                    }
                    if (string.equalsIgnoreCase("ne")) {
                        currentImageURL = neMapSmall;
                        currentBigImageURL = neMapLarge;
                        continue;
                    }
                    if (string.equalsIgnoreCase("nw")) {
                        currentImageURL = nwMapSmall;
                        currentBigImageURL = nwMapLarge;
                        continue;
                    }
                    if (string.equalsIgnoreCase("se")) {
                        currentImageURL = seMapSmall;
                        currentBigImageURL = seMapLarge;
                        continue;
                    }
                    if (string.equalsIgnoreCase("sw")) {
                        currentImageURL = swMapSmall;
                        currentBigImageURL = swMapLarge;
                        continue;
                    }
                    if (string.equalsIgnoreCase("mw")) {
                        currentImageURL = mwMapSmall;
                        currentBigImageURL = mwMapLarge;
                        continue;
                    }
                    currentImageURL = string;
                    currentBigImageURL = string;
                    continue;
                }
                if (stringArray[i].trim().length() > 5) {
                    System.err.println("Invalid zipcode: " + stringArray[i]);
                    return;
                }
                if (stringArray[i].trim().length() < 5) {
                    System.err.println("Invalid zipcode: " + stringArray[i]);
                    return;
                }
                zipcode = Integer.parseInt(stringArray[i].trim());
            }
            if (checkInterval <= 0) {
                checkInterval = 900000;
            }
            if (initialWidth <= 0) {
                initialWidth = 110;
            }
            if (initialHeight <= 0) {
                initialHeight = 167;
            }
            if (zipcode <= 0) {
                System.err.println("Must provide a zipcode.");
                throw new Exception();
            }
            new WeatherMan();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.err.println("Usage:  Java WeatherMan v0.1A");
            System.err.println("java org.jonlin.WeatherMan <options> <zipcode>");
            System.err.println(" <options>");
            System.err.println("   -t <minutes>           The number of minutes the WeatherMan updates the weather information.");
            System.err.println("   -x <width>             The initial width of the window.");
            System.err.println("   -y <height>            The initial height of the window.");
            System.err.println("   -off_x <pixels>        The main x offset.");
            System.err.println("   -off_y <pixels>        The main y offset.");
            System.err.println("   -text_off_x <pixels>   The weather text x offset.");
            System.err.println("   -text_off_y <pixels>   The weather text y offset.");
            System.err.println("   -rv                    Inverse the video (white is black and black is white).");
            System.err.println("   -fg <int> <int> <int>  The Red, Green, and Blue values for the foreground color.");
            System.err.println("   -bg <int> <int> <int>  The Red, Green, and Blue values for the background color.");
            System.err.println("   -fontSize <points>     The font size, in points, to use.");
            System.err.println("   -boldFont              Use bold type font.");
            System.err.println("   -showBigPicture        Show the large weather map window.");
            System.err.println("   -big_x <width>         The initial width of the large weather map window.");
            System.err.println("   -big_y <height>        The initial height of the large weather map window.");
            System.err.println("   -big_off_x <pixels>    The large weather map x offset.");
            System.err.println("   -big_off_y <pixels>    The large weather map y offset.");
            System.err.println("   -showDetails           Show the detailed local weather window.");
            System.err.println("   -detail_x <width>      The initial width of the detialed weather window.");
            System.err.println("   -detail_y <height>     The initial height of the detailed weather window.");
            System.err.println("   -detail_off_x <pixels> The detailed weather window x offset.");
            System.err.println("   -detail_off_y <pixels> The detailed weather window y offset.");
            System.err.println("   -mapType <type>        Use the following detailed map: us = US Map");
            System.err.println("                                                          ne = NE US Map");
            System.err.println("                                                          se = SE US Map");
            System.err.println("                                                          mw = MidWest US Map");
            System.err.println("                                                          nw = NW US Map");
            System.err.println("                                                          sw = SW US Map");
            System.err.println("                                                       or URL of image to use");
            System.err.println("   -dontMerge             This flag prevents Weatherman from overlaying the text on top of the picture.");
            System.err.println("\n");
        }
    }

    public WeatherMan() {
        super("Weather");
        this.setTitle("Weather");
        this.setResizable(true);
        this.setFont(new Font("Monospaced", fontAttrib, fontSize));
        if (bg != null) {
            this.setBackground(bg);
        }
        this.picture = new PicturePanel();
        this.text = new TextPanel();
        if (!dontShowBig) {
            this.bigPicture = new BigPicturePanel();
        }
        if (!dontShowDetail) {
            this.detailText = new DetailedTextPanel();
        }
        this.setSize(initialWidth, initialHeight);
        if (dontMerge) {
            this.setLayout(new GridLayout(2, 1));
            this.add(this.picture);
            this.add(this.text);
            this.pack();
            this.setSize(initialWidth, initialHeight);
        }
        this.weatherThread = new WeatherThread();
        this.show();
        if (!dontShowBig) {
            this.bigPicture.show();
            this.bigPicture.setSize(bigWidth, bigHeight);
            this.bigPicture.show();
        }
        if (!dontShowDetail) {
            this.detailText.show();
            this.detailText.setSize(detailWidth, detailHeight);
            this.detailText.show();
        }
        this.setSize(initialWidth, initialHeight);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        if (dontResize) {
            dimension = this.getSize();
        } else if (dontMerge) {
            Dimension dimension2 = this.text.getPreferredSize();
            Dimension dimension3 = this.picture.getPreferredSize();
            dimension.width = dimension3.width;
            dimension.height = dimension3.height + dimension2.height;
        } else {
            dimension = this.picture.getPreferredSize();
        }
        if (dimension.width <= 10) {
            dimension.width = initialWidth;
        }
        if (dimension.height <= 10) {
            dimension.height = initialHeight;
        }
        return dimension;
    }

    public void setSize() {
        this.setSize(this.getPreferredSize());
    }

    public void update() {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (dontMerge && bg != null) {
            graphics.setColor(bg);
            graphics.fillRect(-500, -500, 7500, 7500);
        }
        if (scaleImage) {
            Dimension dimension = this.getSize();
            if (this.picture.getPreferredSize().width != dimension.width) {
                // empty if block
            }
        }
        if (!dontMerge) {
            this.picture.paint(graphics);
            this.text.paint(graphics);
        } else {
            this.picture.repaint();
            this.text.repaint();
        }
    }

    public void print(String string) {
        System.out.println("[WeatherMan] " + string);
    }

    public void error(String string) {
        System.err.println("{WeatherMan} " + string);
    }

    public void error(String string, Exception exception) {
        System.err.println("{WeatherMan} " + exception + " : " + string);
        exception.printStackTrace(System.err);
    }

    static {
        initialWidth = 168;
        initialHeight = 114;
        textXoffset = 5;
        textYoffset = 25;
        dontResize = true;
        scaleImage = false;
        dontShowBig = true;
        dontShowDetail = true;
        bigWidth = 278;
        bigHeight = 188;
        detailWidth = 530;
        detailHeight = 340;
        detailXoffset = 5;
        detailYoffset = 25;
        fontSize = 11;
        fontAttrib = 0;
    }

    public class WeatherThread
    extends Thread {
        public int currentTemp;
        public int relativeHumidity;
        public float barometer;
        public Vector detailedWeather = new Vector();

        public WeatherThread() {
            super("WeatherThread");
            this.start();
        }

        public void run() {
            boolean bl = true;
            block4: while (true) {
                try {
                    while (true) {
                        WeatherMan.this.repaint();
                        String string = this.getWeatherPage();
                        this.parsePage(string);
                        if (!dontShowDetail) {
                            this.parseDetailPage(string);
                        }
                        this.updateWeatherMan();
                        WeatherMan.this.repaint();
                        if (!dontShowDetail) {
                            WeatherMan.this.detailText.repaint();
                        }
                        if (!dontShowBig) {
                            WeatherMan.this.bigPicture.repaint();
                        }
                        try {
                            WeatherThread.sleep(checkInterval);
                            continue block4;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    WeatherMan.this.error("Error in Weather Gathering Thread.", exception);
                    continue;
                }
                break;
            }
        }

        void updateWeatherMan() {
            try {
                Image image = WeatherMan.this.currentImage;
                WeatherMan.this.currentImage = WeatherMan.this.getToolkit().getImage(new URL(currentImageURL));
                if (image != null) {
                    image.flush();
                }
                if (!dontShowBig) {
                    image = WeatherMan.this.currentBigImage;
                    WeatherMan.this.currentBigImage = WeatherMan.this.getToolkit().getImage(new URL(currentBigImageURL));
                    if (image != null) {
                        image.flush();
                    }
                }
            }
            catch (Exception exception) {
                WeatherMan.this.error("Could not load the current weather image.", exception);
            }
        }

        String getWeatherPage() {
            BufferedWriter bufferedWriter;
            BufferedReader bufferedReader;
            Socket socket;
            String string;
            block16: {
                string = null;
                socket = null;
                bufferedReader = null;
                bufferedWriter = null;
                try {
                    try {
                        socket = new Socket("www.weather.com", 80);
                        socket.setSoTimeout(5000);
                        bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    }
                    catch (Exception exception) {
                        WeatherMan.this.error("Cannot open socket to \"www.weather.com\"", exception);
                    }
                    if (bufferedWriter == null) break block16;
                    bufferedWriter.write("GET /weather/local/" + zipcode + " HTTP/1.1\nConnection: close\nHost: www.weather.com\n\n");
                    bufferedWriter.flush();
                    StringBuffer stringBuffer = new StringBuffer();
                    try {
                        String string2 = bufferedReader.readLine();
                        while (string2 != null) {
                            stringBuffer.append(string2);
                            stringBuffer.append("\n");
                            string2 = bufferedReader.readLine();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string = stringBuffer.toString();
                }
                catch (Exception exception) {
                    WeatherMan.this.error("Error opening \"http://www.weather.com/weather/local/" + zipcode + "\".", exception);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string;
        }

        void parseDetailPage(String string) {
            try {
                int n = string.indexOf("36-Hour Forecast");
                n = string.indexOf("<DIV STYLE=\"padding:5px 5px 5px 0px;\">", n);
                n = string.indexOf(">", n);
                if (n != -1) {
                    String string2 = string.substring(n + 1, string.indexOf("<", n));
                    this.detailedWeather = new Vector();
                    this.detailedWeather.addElement(string2);
                }
            }
            catch (Exception exception) {
                WeatherMan.this.error("Could not parse detailed weather page.", exception);
            }
        }

        void parsePage(String string) {
            try {
                String string2;
                int n = -1;
                n = string.indexOf("<B CLASS=obsTempTextA>");
                if (n > 0) {
                    string = string.substring(n);
                    n = string.indexOf(">");
                    string2 = (string = string.substring(n + 1)).substring(0, n = string.indexOf("&deg;")).trim();
                    if (string2.startsWith("-")) {
                        string2 = string2.substring(1);
                        this.currentTemp = Integer.parseInt(string2) * -1;
                    } else {
                        this.currentTemp = Integer.parseInt(string.substring(0, n).trim());
                    }
                }
                if ((n = string.indexOf("Humidity:")) > 0) {
                    string = string.substring(n);
                    n = string.indexOf("CLASS=\"obsTextA\">");
                    n = string.indexOf(">", n);
                    string2 = (string = string.substring(n + 1)).substring(0, n = string.indexOf("%")).trim();
                    if (string2.startsWith("-")) {
                        string2 = string2.substring(1);
                        this.relativeHumidity = Integer.parseInt(string2) * -1;
                    } else {
                        this.relativeHumidity = Integer.parseInt(string.substring(0, n).trim());
                    }
                }
                if ((n = string.indexOf("Pressure:")) > 0) {
                    string = string.substring(n);
                    n = string.indexOf("CLASS=\"obsTextA\">");
                    n = string.indexOf(">", n);
                    string = string.substring(n + 1);
                    n = string.indexOf("&nbsp");
                    this.barometer = Float.valueOf(string.substring(0, n).trim()).floatValue();
                }
            }
            catch (Exception exception) {
                WeatherMan.this.error("Error parsing HTML containing the weather information.", exception);
            }
        }
    }

    public class TextPanel
    extends Panel {
        int fontHeight;

        public void update() {
            this.repaint();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void paint(Graphics graphics) {
            try {
                if (fg != null) {
                    graphics.setColor(fg);
                }
                FontMetrics fontMetrics = graphics.getFontMetrics();
                this.fontHeight = fontMetrics.getHeight();
                int n = 0;
                if (dontMerge) {
                    n = this.fontHeight;
                }
                if (WeatherMan.this.weatherThread.currentTemp == 0) {
                    graphics.drawString("Fetching", textXoffset, textYoffset + this.fontHeight + n);
                    graphics.drawString("Current", textXoffset, textYoffset + this.fontHeight * 2 + n);
                    graphics.drawString("Weather", textXoffset, textYoffset + this.fontHeight * 3 + n);
                } else {
                    graphics.drawString("T: " + WeatherMan.this.weatherThread.currentTemp + " F", textXoffset, textYoffset + this.fontHeight + n);
                    graphics.drawString("H: " + WeatherMan.this.weatherThread.relativeHumidity + "%", textXoffset, textYoffset + this.fontHeight * 2 + n);
                    graphics.drawString("P: " + WeatherMan.this.weatherThread.barometer + " in", textXoffset, textYoffset + this.fontHeight * 3 + n);
                }
                if (dontResize) return;
            }
            catch (Exception exception) {
                WeatherMan.this.error("Could not draw text for weather information.", exception);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            if (dontResize) {
                dimension = this.getSize();
            } else if (WeatherMan.this.currentImage != null) {
                if (dontMerge) {
                    dimension.width = WeatherMan.this.currentImage.getWidth(null) + 2 * textXoffset;
                    dimension.height = 4 * this.fontHeight + textYoffset;
                } else {
                    dimension = WeatherMan.this.picture.getPreferredSize();
                }
            } else {
                dimension = this.getSize();
            }
            return dimension;
        }
    }

    public class DetailedTextPanel
    extends Frame {
        int fontHeight;

        public DetailedTextPanel() {
            this.setTitle("Detailed Weather Frame");
            this.setBackground(bg);
        }

        public void paint(Graphics graphics) {
            try {
                if (fg != null) {
                    graphics.setColor(fg);
                }
                FontMetrics fontMetrics = graphics.getFontMetrics();
                this.fontHeight = fontMetrics.getHeight();
                int n = detailYoffset + this.fontHeight;
                if (WeatherMan.this.weatherThread.detailedWeather.size() > 0) {
                    for (int i = 0; i < WeatherMan.this.weatherThread.detailedWeather.size(); ++i) {
                        String string = (String)WeatherMan.this.weatherThread.detailedWeather.elementAt(i);
                        graphics.drawString(string, detailXoffset, n);
                        n += this.fontHeight;
                    }
                }
            }
            catch (Exception exception) {
                WeatherMan.this.error("Could not draw text for detailed weather.", exception);
            }
        }
    }

    public class PicturePanel
    extends Panel
    implements ImageObserver {
        public void update() {
            this.repaint();
        }

        public void paint(Graphics graphics) {
            int n = yOffset;
            try {
                if (WeatherMan.this.currentImage != null) {
                    graphics.clearRect(0, 0, 1000, 1000);
                    graphics.drawImage(WeatherMan.this.currentImage, xOffset, yOffset, WeatherMan.this.currentImage.getWidth(null), WeatherMan.this.currentImage.getHeight(null), this);
                    n = n + WeatherMan.this.currentImage.getHeight(null) + 15;
                }
                if (!dontResize) {
                    this.setSize(this.getPreferredSize());
                }
            }
            catch (Exception exception) {
                WeatherMan.this.error("Could not draw current weather image.", exception);
            }
        }

        public void rescaleImage() {
            if (WeatherMan.this.currentImage != null) {
                int n = WeatherMan.this.getSize().width - 2 * yOffset;
                if (n <= 0) {
                    n = 1;
                }
                WeatherMan.this.currentImage = WeatherMan.this.currentImage.getScaledInstance(n, n, 4);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            if (dontResize) {
                dimension = this.getSize();
            } else if (WeatherMan.this.currentImage != null) {
                dimension.width = WeatherMan.this.currentImage.getWidth(null) + 2 * xOffset;
                dimension.height = WeatherMan.this.currentImage.getHeight(null) + 2 * yOffset;
            } else {
                dimension = this.getSize();
            }
            return dimension;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (!dontResize) {
                this.setSize(image.getWidth(null) + 2 * xOffset, image.getHeight(null) + 2 * yOffset);
            }
            WeatherMan.this.setSize();
            WeatherMan.this.repaint();
            return true;
        }
    }

    public class BigPicturePanel
    extends Frame {
        public BigPicturePanel() {
            this.setTitle("Large Current Weather");
            this.setBackground(bg);
        }

        public void paint(Graphics graphics) {
            try {
                if (WeatherMan.this.currentBigImage != null) {
                    graphics.clearRect(0, 0, 1000, 1000);
                    graphics.drawImage(WeatherMan.this.currentBigImage, bigXoffset, bigYoffset, WeatherMan.this.currentBigImage.getWidth(null), WeatherMan.this.currentBigImage.getHeight(null), this);
                }
            }
            catch (Exception exception) {
                WeatherMan.this.error("Could not draw current large weather image.", exception);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            if (dontResize) {
                dimension = this.getSize();
            } else if (WeatherMan.this.currentBigImage != null) {
                dimension.width = WeatherMan.this.currentBigImage.getWidth(null) + 2 * xOffset;
                dimension.height = WeatherMan.this.currentBigImage.getHeight(null) + 2 * yOffset;
            } else {
                dimension = this.getSize();
            }
            return dimension;
        }
    }
}

