/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.xml;

import com.cometway.io.ReaderInputStream;
import com.cometway.xml.XML;
import com.cometway.xml.XMLParserException;
import com.cometway.xml.XMLToken;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;

public class XMLParser {
    protected boolean ignoreWhitespace = true;
    protected boolean decodeEscapeCodes = true;
    protected InputStream dataSource;
    private char cachedChar;
    private boolean useCachedChar;
    private int charCount = 0;
    private int length = -1;

    public XMLParser(String string) {
        this.dataSource = new ReaderInputStream(new StringReader(string));
    }

    public XMLParser(InputStream inputStream) {
        this.dataSource = inputStream;
    }

    public void close() throws XMLParserException {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (IOException iOException) {
                throw new XMLParserException("Could not close InputStream: " + this.dataSource, iOException);
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    public void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    public void setDecodeEscapeCodes(boolean bl) {
        this.decodeEscapeCodes = bl;
    }

    private char nextChar() throws IOException, EOFException {
        if (this.length > 0 && this.charCount > this.length) {
            throw new EOFException("Length has been reached.");
        }
        ++this.charCount;
        int n = this.dataSource.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (char)n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public XMLToken nextToken() throws XMLParserException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c = '0';
            if (!this.useCachedChar) {
                c = this.nextChar();
            } else {
                c = this.cachedChar;
                this.useCachedChar = false;
            }
            if (c == '<') {
                stringBuffer.append(c);
                boolean bl = false;
                boolean bl2 = false;
                c = this.nextChar();
                while (c == ' ' || c == '\n' || c == '\t') {
                    if (!this.ignoreWhitespace) {
                        stringBuffer.append(c);
                    }
                    c = this.nextChar();
                }
                if (c == '/') {
                    n = 3;
                    stringBuffer.append(c);
                    c = this.nextChar();
                } else {
                    n = 1;
                }
                boolean bl3 = false;
                while (bl2 || bl || c != '>') {
                    if (c == '\"') {
                        if (!bl2) {
                            bl = !bl;
                        }
                        bl3 = false;
                        stringBuffer.append(c);
                    } else if (c == '\'') {
                        if (!bl) {
                            bl2 = !bl2;
                        }
                        bl3 = false;
                        stringBuffer.append(c);
                    } else if (c == '/') {
                        if (!bl && !bl2) {
                            bl3 = true;
                        }
                        stringBuffer.append(c);
                    } else {
                        if (c != ' ' && c != '\n' && c != '\t') {
                            bl3 = false;
                        }
                        stringBuffer.append(c);
                    }
                    c = this.nextChar();
                }
                stringBuffer.append(c);
                if (bl3) {
                    n = 0;
                }
            } else {
                n = 2;
                stringBuffer.append(c);
                c = this.nextChar();
                while (c != '<') {
                    stringBuffer.append(c);
                    c = this.nextChar();
                }
                this.cachedChar = c;
                this.useCachedChar = true;
                if (this.decodeEscapeCodes) {
                    stringBuffer = new StringBuffer(XML.decode(stringBuffer.toString()));
                }
            }
            if (this.ignoreWhitespace) {
                if (stringBuffer.toString().trim().length() == 0) {
                    return this.nextToken();
                }
                stringBuffer = new StringBuffer(stringBuffer.toString().trim());
            }
        }
        catch (Exception exception) {
            throw new XMLParserException(exception.getMessage(), exception);
        }
        return new XMLToken(n, stringBuffer.toString());
    }

    public XMLToken nextToken(String string) throws XMLParserException {
        XMLToken xMLToken = this.nextToken();
        if (!xMLToken.data.equals(string)) {
            throw new XMLParserException("Unexpected token: " + xMLToken.data);
        }
        return xMLToken;
    }

    public XMLToken nextStartTag() throws XMLParserException {
        XMLToken xMLToken = this.nextToken();
        if (xMLToken.type != 1) {
            throw new XMLParserException("Unexpected token: " + xMLToken.data);
        }
        return xMLToken;
    }

    public XMLToken nextEndTag() throws XMLParserException {
        XMLToken xMLToken = this.nextToken();
        if (xMLToken.type != 3) {
            throw new XMLParserException("Unexpected token: " + xMLToken.data);
        }
        return xMLToken;
    }

    public XMLToken nextElementContent() throws XMLParserException {
        XMLToken xMLToken = this.nextToken();
        if (xMLToken.type != 2) {
            throw new XMLParserException("Unexpected token: " + xMLToken.data);
        }
        return xMLToken;
    }

    public XMLToken nextEmptyElementTag() throws XMLParserException {
        XMLToken xMLToken = this.nextToken();
        if (xMLToken.type != 0) {
            throw new XMLParserException("Unexpected token: " + xMLToken.data);
        }
        return xMLToken;
    }
}

