/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.util;

import com.cometway.util.Pair;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class StringTools {
    private static final String kBinHexHeaderString = "(This file must be converted with BinHex";
    private static final String kBinHexDecodeString = "!\"#$%&'()*+,-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr";

    public static String decodeBinHex(String string) {
        return StringTools.decodeBinHex(string, true, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decodeBinHex(String string, boolean bl, boolean bl2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            n = string.indexOf(kBinHexHeaderString);
            if (n == -1) throw new Exception();
            n += kBinHexHeaderString.length();
            if ((n = string.indexOf(":", n)) == -1) throw new Exception();
            if ((n = (string = string.substring(n + 1)).indexOf(":")) == -1) {
                throw new Exception();
            }
            string = string.substring(0, n);
        }
        catch (Exception exception) {
            if (!bl2) return "";
            System.err.println("StringTools.decodeBinHex(): Error reading BinHex 4.0 header");
            return "";
        }
        try {
            object = new boolean[24];
            byte[] byArray = new byte[3];
            for (int i = 0; i < string.length(); ++i) {
                int n2;
                block16: {
                    n = 0;
                    do {
                        if ((n2 = kBinHexDecodeString.indexOf(string.charAt(i))) != -1) {
                            for (int j = 0; j < 6; ++j) {
                                object[n * 6 + (5 - j)] = n2 % 2 == 1 ? (Object)true : (Object)false;
                                n2 /= 2;
                            }
                        } else {
                            if (!bl2) throw new Exception();
                            System.err.println("StringTools.decodeBinHex(): Read a non BinHex 4.0 character while decoding.");
                            throw new Exception();
                        }
                        if (++i != string.length()) continue;
                        ++n;
                        break block16;
                    } while (++n != 4);
                    --i;
                }
                if (n < 4) {
                    for (n2 = 0; n2 < 24 - n * 6; ++n2) {
                        object[n * 4 + n2] = false;
                    }
                    n += 2;
                }
                n = n * 3 / 4;
                for (n2 = 0; n2 < n; ++n2) {
                    long l = 0L;
                    for (int j = 0; j < 8; ++j) {
                        if (object[n2 * 8 + (7 - j)] == false) continue;
                        l += (long)Math.pow(2.0, j);
                    }
                    byArray[n2] = (byte)l;
                }
                stringBuffer.append(new String(byArray, 0, n));
            }
        }
        catch (Exception exception) {
            if (!bl2) return "";
            System.err.println("StringTools.decodeBinHex(): Error encountered while decoding BinHex 4.0 data.");
            return "";
        }
        if (!bl) return stringBuffer.toString();
        try {
            object = stringBuffer.toString();
            int n3 = 0;
            n = ((String)object).charAt(0);
            n += 12;
            n3 = ((String)object).charAt(n++) * 0x1000000 + n3;
            n3 = ((String)object).charAt(n++) * 65536 + n3;
            n3 = ((String)object).charAt(n++) * 256 + n3;
            n3 = ((String)object).charAt(n++) * '\u0001' + n3;
            stringBuffer = new StringBuffer(((String)object).substring(n += 6, n + n3));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            if (!bl2) return stringBuffer.toString();
            System.err.println("StringTools.decodeBinHex(): Error encountered while decoding BinHex 4.0 data.");
        }
        return stringBuffer.toString();
    }

    public static String[] commaToArray(String string) {
        String[] stringArray = new String[]{};
        if (string != null) {
            try {
                Vector<String> vector = new Vector<String>();
                int n = string.indexOf(",");
                while (n != -1) {
                    String string2 = string.substring(0, n);
                    vector.addElement(string2.trim());
                    string = string.substring(n + 1);
                    n = string.indexOf(",");
                }
                if (string.trim().length() > 0) {
                    vector.addElement(string.trim());
                }
                if (vector.size() > 0) {
                    stringArray = new String[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        stringArray[i] = (String)vector.elementAt(i);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringArray;
    }

    public static Dimension getDimension(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        String string2 = "\n";
        if (string.indexOf("\r\n") != -1) {
            string2 = "\r\n";
        } else if (string.indexOf("\n\r") != -1) {
            string2 = "\n\r";
        }
        if (string.indexOf(string2) == -1) {
            string2 = "\r";
            if (string.indexOf(string2) == -1) {
                if (n2 == 0) {
                    return new Dimension(0, 0);
                }
                return new Dimension(n2, 1);
            }
            n = n4 = string.indexOf(string2);
            n3 = 1;
        } else {
            n = n4 = string.indexOf(string2);
            n3 = 1;
            if (string.lastIndexOf(string2) < string.length() - string2.length()) {
                string = string + string2;
            }
        }
        try {
            int n5 = string.indexOf(string2, n + 1);
            while (n5 != -1) {
                ++n3;
                if (n4 < n5 - (n + string2.length())) {
                    n4 = n5 - (n + string2.length());
                }
                n = n5;
                n5 = string.indexOf(string2, n + 1);
            }
        }
        catch (Exception exception) {
            System.out.println("Unexpected error: " + exception);
        }
        return new Dimension(n4, n3);
    }

    public static int getIntParam(String[] stringArray, String string) {
        int n = 0;
        String string2 = StringTools.getParam(stringArray, string);
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public static String getParam(String[] stringArray, String string) {
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string) || stringArray.length <= i + 1) continue;
            string2 = stringArray[++i];
        }
        return string2;
    }

    public static boolean hasParam(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String removeHTMLTags(String string) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                if (bl) {
                    bl2 = !bl2;
                } else if (!bl && bl2) {
                    bl2 = false;
                }
            }
            if (!bl2 && string.charAt(i) == '<') {
                bl = true;
            }
            if (!bl) {
                if (string.charAt(i) == '&') {
                    int n = i + 1;
                    if (n < string.length()) {
                        if (string.indexOf("lt", n) == n) {
                            stringBuffer.append("<");
                            i = n + 1;
                        } else if (string.indexOf("gt", n) == n) {
                            stringBuffer.append(">");
                            i = n + 1;
                        } else if (string.indexOf("amp", n) == n) {
                            stringBuffer.append("&");
                            i = n + 2;
                        } else if (string.indexOf("quot", n) == n) {
                            stringBuffer.append("\"");
                            i = n + 3;
                        } else if (string.indexOf("nbsp", n) == n) {
                            stringBuffer.append(" ");
                            i = n + 3;
                        } else if (string.indexOf("reg", n) == n) {
                            stringBuffer.append("(R)");
                            i = n + 2;
                        } else if (string.indexOf("copy", n) == n) {
                            stringBuffer.append("(c)");
                            i = n + 3;
                        } else if (string.indexOf("ensp", n) == n) {
                            stringBuffer.append(" ");
                            i = n + 3;
                        } else if (string.indexOf("emsp", n) == n) {
                            stringBuffer.append(" ");
                            i = n + 3;
                        } else if (string.indexOf("endash", n) == n) {
                            stringBuffer.append("-");
                            i = n + 5;
                        } else if (string.indexOf("emdash", n) == n) {
                            stringBuffer.append("-");
                            i = n + 5;
                        } else {
                            stringBuffer.append(string.charAt(i));
                        }
                    } else {
                        stringBuffer.append(string.charAt(i));
                    }
                } else {
                    stringBuffer.append(string.charAt(i));
                }
            }
            if (bl2 || string.charAt(i) != '>') continue;
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static Vector pairCaseSensitiveSort(Vector vector) {
        Vector vector2 = new Vector();
        if (vector.size() > 1) {
            int n;
            Pair[] pairArray = new Pair[vector.size()];
            Enumeration enumeration = vector.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || !(e instanceof Pair)) continue;
                pairArray[n2] = (Pair)e;
                ++n2;
            }
            boolean bl = false;
            while (!bl) {
                bl = true;
                for (n = 0; n < pairArray.length - 1; ++n) {
                    if (((String)pairArray[n].first()).compareTo((String)pairArray[n + 1].first()) <= 0) continue;
                    Pair pair = pairArray[n];
                    pairArray[n] = pairArray[n + 1];
                    pairArray[n + 1] = pair;
                    bl = false;
                }
            }
            for (n = 0; n < pairArray.length; ++n) {
                vector2.addElement(pairArray[n]);
            }
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public static String truncateString(Graphics graphics, String string, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (n > fontMetrics.stringWidth(string)) {
            return string;
        }
        int n2 = fontMetrics.stringWidth("...");
        if (n2 > n) {
            n2 = fontMetrics.stringWidth("..");
            if (n2 > n) {
                n2 = fontMetrics.stringWidth(".");
                if (n2 > n) {
                    return "";
                }
                return ".";
            }
            return "..";
        }
        while (n <= fontMetrics.stringWidth(string) + n2) {
            string = string.substring(0, string.length() - 1);
        }
        return string + "...";
    }

    public static Vector pairSort(Vector vector) {
        Vector vector2 = new Vector();
        if (vector.size() > 1) {
            int n;
            Pair[] pairArray = new Pair[vector.size()];
            Enumeration enumeration = vector.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || !(e instanceof Pair)) continue;
                pairArray[n2] = new Pair(((String)((Pair)e).first()).toLowerCase(), (Pair)e);
                ++n2;
            }
            boolean bl = false;
            while (!bl) {
                bl = true;
                for (n = 0; n < pairArray.length - 1; ++n) {
                    if (((String)pairArray[n].first()).compareTo((String)pairArray[n + 1].first()) <= 0) continue;
                    Pair pair = pairArray[n];
                    pairArray[n] = pairArray[n + 1];
                    pairArray[n + 1] = pair;
                    bl = false;
                }
            }
            for (n = 0; n < pairArray.length; ++n) {
                vector2.addElement(pairArray[n].second());
            }
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public Vector intersection(String[] stringArray, String[] stringArray2) {
        int n;
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector.addElement(new Pair(stringArray[n], null));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            vector.addElement(new Pair(stringArray2[n], null));
        }
        vector = StringTools.pairSort(vector);
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            Pair pair = (Pair)vector.elementAt(i);
            if (i != 0) {
                if (string.equals((String)pair.first())) {
                    vector2.addElement(string);
                    continue;
                }
                string = (String)pair.first();
                continue;
            }
            string = (String)pair.first();
        }
        return vector2;
    }

    public Vector intersection(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n;
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector.addElement(new Pair(stringArray[n], null));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            vector.addElement(new Pair(stringArray2[n], null));
        }
        for (n = 0; n < stringArray3.length; ++n) {
            vector.addElement(new Pair(stringArray3[n], null));
        }
        vector = StringTools.pairSort(vector);
        n = 0;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            Pair pair = (Pair)vector.elementAt(i);
            if (i != 0) {
                if (string.equals((String)pair.first())) {
                    if (n != 0) {
                        vector2.addElement(string);
                        n = 0;
                        continue;
                    }
                    n = 1;
                    continue;
                }
                string = (String)pair.first();
                n = 0;
                continue;
            }
            string = (String)pair.first();
        }
        return vector2;
    }

    public static String[] parseArgs(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = "";
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                if (bl && !bl2) {
                    vector.addElement(string2);
                    string2 = "";
                    bl = false;
                } else if (bl2) {
                    if (bl) {
                        string2 = string2 + "\"";
                    } else {
                        vector.addElement(string2);
                        string2 = "\"";
                    }
                } else if (!bl) {
                    if (!string2.equals("")) {
                        vector.addElement(string2);
                        string2 = "";
                    }
                    bl = true;
                }
                bl2 = false;
                continue;
            }
            if (c == ' ') {
                if (bl) {
                    string2 = string2 + " ";
                } else if (!string2.equals("")) {
                    vector.addElement(string2);
                    string2 = "";
                }
                bl2 = false;
                continue;
            }
            if (c == '\\') {
                if (bl2 || !bl) {
                    string2 = string2 + "\\";
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            string2 = string2 + c;
            bl2 = false;
        }
        if (!string2.equals("")) {
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

