/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class ObjectSerializer {
    public static Object unserialize(byte[] byArray) throws IOException, OptionalDataException, ClassNotFoundException {
        return ObjectSerializer.unserialize(byArray, 0, byArray.length);
    }

    public static Object unserialize(byte[] byArray, int n, int n2) throws IOException, OptionalDataException, ClassNotFoundException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new IOException("Cannot unserialize byte array");
        }
    }

    public static byte[] serialize(Object object) throws IOException, NotSerializableException {
        if (object instanceof Serializable) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            return byArray;
        }
        throw new NotSerializableException(object.toString());
    }
}

