/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTools {
    public static final int kDaysPerWeek = 7;
    public static final int kMonthsPerYear = 12;
    protected static final String[] daysTable = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    protected static final String[] monthsTable = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final SimpleDateFormat ISO8601_DATETIMEFORMAT = new SimpleDateFormat("yyyyMMdd HHmmss");
    public static final SimpleDateFormat ISO8601_DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat ISO8601_TIMEFORMAT = new SimpleDateFormat("HHmmss");

    public static String toISO8601String(Date date) {
        return ISO8601_DATEFORMAT.format(date) + "T" + ISO8601_TIMEFORMAT.format(date);
    }

    public static Date parseISO8601String(String string) throws ParseException {
        string = string.replace('T', ' ');
        return ISO8601_DATETIMEFORMAT.parse(string);
    }

    public static String getAbbrDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTools.getMonth(calendar.get(2), 3) + " " + String.valueOf(calendar.get(5)) + ", " + String.valueOf(calendar.get(1));
    }

    public static String getAbbrDate(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return DateTools.getMonth(calendar.get(2), 3) + " " + String.valueOf(calendar.get(5)) + ", " + String.valueOf(calendar.get(1));
    }

    public static String getDay(int n) {
        return daysTable[n];
    }

    public static String getDay(int n, int n2) {
        return new String(daysTable[n].substring(0, n2));
    }

    public static String getLongDate(Date date) {
        String string = new String();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        string = string + DateTools.getMonth(calendar.get(2)) + " ";
        string = string + String.valueOf(calendar.get(5)) + ", ";
        string = string + String.valueOf(calendar.get(1));
        return string;
    }

    public static String getLongDate(Date date, TimeZone timeZone) {
        String string = new String();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        string = string + DateTools.getMonth(calendar.get(2)) + " ";
        string = string + String.valueOf(calendar.get(5)) + ", ";
        string = string + String.valueOf(calendar.get(1));
        return string;
    }

    public static String getMonth(int n) {
        return monthsTable[n];
    }

    public static String getMonth(int n, int n2) {
        return monthsTable[n].substring(0, n2);
    }

    public static String getShortDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(2) + 1) + "/" + String.valueOf(calendar.get(5)) + "/" + String.valueOf(calendar.get(1) % 100);
    }

    public static String getShortDate(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return String.valueOf(calendar.get(2) + 1) + "/" + String.valueOf(calendar.get(5)) + "/" + String.valueOf(calendar.get(1) % 100);
    }

    public static String getShortDateTime(Date date, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        stringBuffer.append(calendar.get(2) + 1 + "/" + calendar.get(5));
        if (bl) {
            stringBuffer.append("/" + calendar.get(1) % 100);
        }
        stringBuffer.append("  ");
        stringBuffer.append(DateTools.getTime(date, bl2));
        return stringBuffer.toString();
    }

    public static String getShortDateTime(Date date, boolean bl, boolean bl2, TimeZone timeZone) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        stringBuffer.append(calendar.get(2) + 1 + "/" + calendar.get(5));
        if (bl) {
            stringBuffer.append("/" + calendar.get(1) % 100);
        }
        stringBuffer.append("  ");
        stringBuffer.append(DateTools.getTime(date, bl2, timeZone));
        return stringBuffer.toString();
    }

    public static String getTime(Date date, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        if (n == 0) {
            stringBuffer.append(12);
        } else if (n > 12) {
            stringBuffer.append(n - 12);
        } else {
            stringBuffer.append(n);
        }
        if (n2 < 10) {
            stringBuffer.append(":0" + n2);
        } else {
            stringBuffer.append(":" + n2);
        }
        if (bl) {
            if (n3 < 10) {
                stringBuffer.append(":0" + n3);
            } else {
                stringBuffer.append(":" + n3);
            }
        }
        if (n < 12) {
            stringBuffer.append(" AM");
        } else {
            stringBuffer.append(" PM");
        }
        stringBuffer.append(" " + TimeZone.getDefault().getID());
        return stringBuffer.toString();
    }

    public static String getTime(Date date, boolean bl, TimeZone timeZone) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        if (n == 0) {
            stringBuffer.append(12);
        } else if (n > 12) {
            stringBuffer.append(n - 12);
        } else {
            stringBuffer.append(n);
        }
        if (n2 < 10) {
            stringBuffer.append(":0" + n2);
        } else {
            stringBuffer.append(":" + n2);
        }
        if (bl) {
            if (n3 < 10) {
                stringBuffer.append(":0" + n3);
            } else {
                stringBuffer.append(":" + n3);
            }
        }
        if (n < 12) {
            stringBuffer.append(" AM");
        } else {
            stringBuffer.append(" PM");
        }
        stringBuffer.append(" " + timeZone.getID());
        return stringBuffer.toString();
    }

    public static Date today() {
        return new Date();
    }

    public static String toRFC822String(Date date) {
        if (date == null) {
            date = new Date();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(7) - 1;
        if (n == 0) {
            stringBuffer.append("Sun, ");
        } else if (n == 1) {
            stringBuffer.append("Mon, ");
        } else if (n == 2) {
            stringBuffer.append("Tue, ");
        } else if (n == 3) {
            stringBuffer.append("Wed, ");
        } else if (n == 4) {
            stringBuffer.append("Thu, ");
        } else if (n == 5) {
            stringBuffer.append("Fri, ");
        } else if (n == 6) {
            stringBuffer.append("Sat, ");
        }
        n = calendar.get(5);
        if (n > 9) {
            stringBuffer.append(n + " ");
        } else {
            stringBuffer.append("0" + n + " ");
        }
        n = calendar.get(2);
        if (n == 0) {
            stringBuffer.append("Jan ");
        } else if (n == 1) {
            stringBuffer.append("Feb ");
        } else if (n == 2) {
            stringBuffer.append("Mar ");
        } else if (n == 3) {
            stringBuffer.append("Apr ");
        } else if (n == 4) {
            stringBuffer.append("May ");
        } else if (n == 5) {
            stringBuffer.append("Jun ");
        } else if (n == 6) {
            stringBuffer.append("Jul ");
        } else if (n == 7) {
            stringBuffer.append("Aug ");
        } else if (n == 8) {
            stringBuffer.append("Sep ");
        } else if (n == 9) {
            stringBuffer.append("Oct ");
        } else if (n == 10) {
            stringBuffer.append("Nov ");
        } else if (n == 11) {
            stringBuffer.append("Dec ");
        }
        n = calendar.get(1);
        stringBuffer.append(n + " ");
        n = calendar.get(11);
        if (n < 10) {
            stringBuffer.append("0" + n + ":");
        } else {
            stringBuffer.append(n + ":");
        }
        n = calendar.get(12);
        if (n < 10) {
            stringBuffer.append("0" + n + ":");
        } else {
            stringBuffer.append(n + ":");
        }
        n = calendar.get(13);
        if (n < 10) {
            stringBuffer.append("0" + n + " ");
        } else {
            stringBuffer.append(n + " ");
        }
        n = calendar.get(15) / 60000;
        if (n == 0) {
            stringBuffer.append("+00");
        } else if (n / 60 > 9) {
            stringBuffer.append("+" + n / 60 + "");
        } else if (n / 60 < -9) {
            stringBuffer.append(n / 60 + "");
        } else if (n / 60 > 0) {
            stringBuffer.append("+0" + Math.abs(n / 60));
        } else {
            stringBuffer.append("-0" + Math.abs(n / 60));
        }
        if (n % 60 == 0) {
            stringBuffer.append("00");
        } else {
            stringBuffer.append(Math.abs(n % 60));
        }
        return stringBuffer.toString();
    }

    public static String toRFC822String(Date date, TimeZone timeZone) {
        if (date == null) {
            date = new Date();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int n = calendar.get(7) - 1;
        if (n == 0) {
            stringBuffer.append("Sun, ");
        } else if (n == 1) {
            stringBuffer.append("Mon, ");
        } else if (n == 2) {
            stringBuffer.append("Tue, ");
        } else if (n == 3) {
            stringBuffer.append("Wed, ");
        } else if (n == 4) {
            stringBuffer.append("Thu, ");
        } else if (n == 5) {
            stringBuffer.append("Fri, ");
        } else if (n == 6) {
            stringBuffer.append("Sat, ");
        }
        n = calendar.get(5);
        if (n > 9) {
            stringBuffer.append(n + " ");
        } else {
            stringBuffer.append("0" + n + " ");
        }
        n = calendar.get(2);
        if (n == 0) {
            stringBuffer.append("Jan ");
        } else if (n == 1) {
            stringBuffer.append("Feb ");
        } else if (n == 2) {
            stringBuffer.append("Mar ");
        } else if (n == 3) {
            stringBuffer.append("Apr ");
        } else if (n == 4) {
            stringBuffer.append("May ");
        } else if (n == 5) {
            stringBuffer.append("Jun ");
        } else if (n == 6) {
            stringBuffer.append("Jul ");
        } else if (n == 7) {
            stringBuffer.append("Aug ");
        } else if (n == 8) {
            stringBuffer.append("Sep ");
        } else if (n == 9) {
            stringBuffer.append("Oct ");
        } else if (n == 10) {
            stringBuffer.append("Nov ");
        } else if (n == 11) {
            stringBuffer.append("Dec ");
        }
        n = calendar.get(1);
        stringBuffer.append(n + " ");
        n = calendar.get(11);
        if (n < 10) {
            stringBuffer.append("0" + n + ":");
        } else {
            stringBuffer.append(n + ":");
        }
        n = calendar.get(12);
        if (n < 10) {
            stringBuffer.append("0" + n + ":");
        } else {
            stringBuffer.append(n + ":");
        }
        n = calendar.get(13);
        if (n < 10) {
            stringBuffer.append("0" + n + " ");
        } else {
            stringBuffer.append(n + " ");
        }
        n = calendar.get(15) / 60000;
        if (n == 0) {
            stringBuffer.append("+00");
        } else if (n / 60 > 9) {
            stringBuffer.append("+" + n / 60 + "");
        } else if (n / 60 < -9) {
            stringBuffer.append(n / 60 + "");
        } else if (n / 60 > 0) {
            stringBuffer.append("+0" + Math.abs(n / 60));
        } else {
            stringBuffer.append("-0" + Math.abs(n / 60));
        }
        if (n % 60 == 0) {
            stringBuffer.append("00");
        } else {
            stringBuffer.append(Math.abs(n % 60));
        }
        return stringBuffer.toString();
    }
}

