/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.props;

import com.cometway.httpd.HTMLFormWriter;
import com.cometway.httpd.HTMLStringTools;
import com.cometway.props.Props;
import com.cometway.props.PropsException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropsSchema {
    protected static final String EOL = System.getProperty("line.separator");
    protected static final int DEFAULT_SIZE = 96;
    protected List schema;

    public PropsSchema() {
        this.schema = new Vector();
    }

    public PropsSchema(List list) {
        this.schema = list;
    }

    public PropsSchema(String string) throws PropsException {
        this.schema = PropsSchema.parse(string);
    }

    public void add(Props props) {
        this.schema.add(props);
    }

    public Props addBoolean(String string, String string2) {
        Props props = new Props();
        props.setProperty("key", string2);
        props.setProperty("label", string);
        props.setProperty("type", "boolean");
        this.schema.add(props);
        return props;
    }

    public Props addButton(String string, String string2, String string3) {
        Props props = new Props();
        props.setProperty("key", string);
        props.setProperty("title", string2);
        props.setProperty("description", string3);
        props.setProperty("type", "button");
        this.schema.add(props);
        return props;
    }

    public Props addCaption(String string) {
        Props props = new Props();
        props.setProperty("caption", string);
        props.setProperty("key", "*");
        props.setProperty("type", "caption");
        this.schema.add(props);
        return props;
    }

    public Props addChoice(String string, String string2, String string3) {
        Props props = new Props();
        props.setProperty("options", string3);
        props.setProperty("key", string2);
        props.setProperty("label", string);
        props.setProperty("type", "choice");
        this.schema.add(props);
        return props;
    }

    public Props addInteger(String string, String string2) {
        Props props = new Props();
        props.setProperty("key", string2);
        props.setProperty("label", string);
        props.setProperty("type", "integer");
        this.schema.add(props);
        return props;
    }

    public Props addString(String string, String string2) {
        Props props = new Props();
        props.setProperty("key", string2);
        props.setProperty("label", string);
        props.setProperty("type", "string");
        this.schema.add(props);
        return props;
    }

    public Props addString(String string, String string2, int n) {
        Props props = new Props();
        props.setProperty("key", string2);
        props.setProperty("label", string);
        props.setInteger("lines", n);
        props.setProperty("type", "string");
        this.schema.add(props);
        return props;
    }

    public Props addSpace() {
        Props props = new Props();
        props.setProperty("key", "*");
        props.setProperty("type", "space");
        this.schema.add(props);
        return props;
    }

    public Props getFieldSchema(String string) {
        Props props = null;
        int n = this.schema.size();
        for (int i = 0; i < n; ++i) {
            Props props2 = (Props)this.schema.get(i);
            String string2 = props2.getString("key");
            if (!string2.equals(string)) continue;
            props = props2;
            break;
        }
        return props;
    }

    public List getListSchema() {
        Vector<Props> vector = new Vector<Props>();
        int n = this.schema.size();
        for (int i = 0; i < n; ++i) {
            Props props = (Props)this.schema.get(i);
            if (!props.getBoolean("list")) continue;
            vector.add(props);
        }
        return vector;
    }

    public String getPrimaryKey() {
        String string = null;
        int n = this.schema.size();
        for (int i = 0; i < n; ++i) {
            Props props = (Props)this.schema.get(i);
            if (!props.getBoolean("primary")) continue;
            string = props.getString("key");
            break;
        }
        return string;
    }

    public List getSchema() {
        return this.schema;
    }

    public void setSchema(String string) throws PropsException {
        this.schema = PropsSchema.parse(string);
    }

    public String toString() {
        return PropsSchema.toString(this.schema);
    }

    public void writeForm(HTMLFormWriter hTMLFormWriter) throws IOException {
        this.writeForm(hTMLFormWriter, new Props(), 96);
    }

    public void writeForm(HTMLFormWriter hTMLFormWriter, Props props) throws IOException {
        this.writeForm(hTMLFormWriter, props, 96);
    }

    public void writeForm(HTMLFormWriter hTMLFormWriter, Props props, int n) throws IOException {
        int n2 = this.schema.size();
        for (int i = 0; i < n2; ++i) {
            Props props2 = (Props)this.schema.get(i);
            this.writeFormElement(hTMLFormWriter, props2, props, n);
        }
    }

    public void writeFormElement(HTMLFormWriter hTMLFormWriter, Props props, Props props2, int n) throws IOException {
        String string = props.getString("key");
        String string2 = props.getString("label");
        String string3 = props.getString("type");
        String string4 = props.getString("help");
        if (string4.length() > 0) {
            hTMLFormWriter.writeHelp(string4);
        }
        if (string3.equals("boolean")) {
            hTMLFormWriter.writeCheckbox(string2, string, props2.getBoolean(string));
        } else if (string3.equals("button")) {
            String string5 = props.getString("title");
            String string6 = props.getString("description");
            hTMLFormWriter.writeSubmitButton(string5, string, string6);
        } else if (string3.equals("caption")) {
            String string7 = props.getString("caption");
            hTMLFormWriter.writeCaption(string7);
        } else if (string3.equals("choice")) {
            hTMLFormWriter.writeSelectHeader(string2, string, false);
            String string8 = props2.getString(string);
            Vector vector = props.getTokens("options");
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                String string9 = (String)vector.get(i);
                hTMLFormWriter.writeSelectItem(string9, string9, string8.equals(string9));
            }
            hTMLFormWriter.writeSelectFooter();
        } else if (string3.equals("password")) {
            String string10 = props2.getString(string);
            int n3 = props.getInteger("size");
            if (n3 == 0) {
                n3 = n;
            }
            hTMLFormWriter.writePassword(string2, string, string10, n3);
        } else if (string3.equals("space")) {
            hTMLFormWriter.writeSpace();
        } else if (string3.equals("hidden")) {
            String string11 = props.getTrimmedString("value");
            if (string11.length() > 0) {
                hTMLFormWriter.writeHiddenField(string, string11);
            } else {
                hTMLFormWriter.writeHiddenField(string, props2);
            }
        } else if (string3.equals("html")) {
            int n4 = props.getInteger("lines");
            int n5 = props.getInteger("size");
            String string12 = props.getTrimmedString("format");
            String string13 = props2.getString(string);
            if (n5 == 0) {
                n5 = n;
            }
            if (string12.equals("plaintext")) {
                string13 = HTMLStringTools.convertHTMLToPlainText(string13);
            }
            if (n4 < 2) {
                hTMLFormWriter.writeField(string2, string, string13, n5);
            } else {
                hTMLFormWriter.writeMultilineField(string2, string, string13, n5, n4);
            }
        } else {
            int n6 = props.getInteger("lines");
            int n7 = props.getInteger("size");
            String string14 = props2.getString(string);
            if (n7 == 0) {
                n7 = n;
            }
            if (n6 < 2) {
                hTMLFormWriter.writeField(string2, string, string14, n7);
            } else {
                hTMLFormWriter.writeMultilineField(string2, string, string14, n7, n6);
            }
        }
    }

    public static List parse(String string) throws PropsException {
        Vector<Props> vector = new Vector<Props>();
        Props props = null;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{:;}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            if (string4.equals("{")) {
                if (props != null) continue;
                throw new PropsException("Unexpected '{' in PropsSchema (key = " + string2 + ").");
            }
            if (string4.equals("}")) {
                if (props == null) {
                    throw new PropsException("Unexpected '}' in PropsSchema (key = " + string2 + ").");
                }
                vector.add(props);
                props = null;
                continue;
            }
            if (string4.equals(":")) {
                if (props == null || string2 == null) {
                    throw new PropsException("Unexpected ':' in PropsSchema (key = " + string2 + ").");
                }
                if (string3 != null) {
                    string3 = string3 + ':';
                    continue;
                }
                string3 = new String();
                continue;
            }
            if (string4.equals(";")) {
                if (props == null || string2 == null || string3 == null) {
                    throw new PropsException("Unexpected ';' in PropsSchema (key = " + string2 + ").");
                }
                props.setProperty(string2, string3);
                string2 = null;
                string3 = null;
                continue;
            }
            if (props == null) {
                props = new Props();
                props.setProperty("key", string4);
                continue;
            }
            if (string4.length() <= 0) continue;
            if (string2 == null) {
                string2 = string4;
                continue;
            }
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            string3 = string3 + string4;
        }
        return vector;
    }

    public static String toString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Props props = (Props)list.get(i);
            String string = props.getString("key");
            stringBuffer.append(string);
            stringBuffer.append(" { ");
            Vector vector = props.getKeys();
            int n2 = vector.size();
            Collections.sort(vector);
            for (int j = 0; j < n2; ++j) {
                string = (String)vector.get(j);
                if (string.equals("key")) continue;
                String string2 = props.getTrimmedString(string);
                stringBuffer.append(string);
                stringBuffer.append(": ");
                stringBuffer.append(string2);
                stringBuffer.append("; ");
            }
            stringBuffer.append('}');
            stringBuffer.append(EOL);
        }
        return stringBuffer.toString();
    }
}

