/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.props;

import com.cometway.props.IPropsChangeListener;
import com.cometway.props.IPropsContainer;
import com.cometway.props.PropsContainer;
import com.cometway.props.PropsException;
import com.cometway.props.PropsSchema;
import com.cometway.props.VectorPropsContainer;
import com.cometway.util.DateTools;
import com.cometway.util.ObjectSerializer;
import com.cometway.util.Pair;
import com.cometway.util.StringTools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Props {
    private static final DateFormat ISO8601_DATEFORMAT = DateTools.ISO8601_DATEFORMAT;
    private static final String EOL = System.getProperty("line.separator");
    private IPropsContainer container;
    private int suspendNotify;
    private Vector listeners;
    private Vector changedProps;
    private Object listenerSync;

    public Props() {
        this.container = new PropsContainer();
    }

    public Props(IPropsContainer iPropsContainer) {
        if (iPropsContainer == null) {
            throw new NullPointerException("container is null");
        }
        this.container = iPropsContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(IPropsChangeListener iPropsChangeListener) {
        boolean bl = this.listeners.contains(iPropsChangeListener);
        if (!bl) {
            Object object = this.listenerSync;
            synchronized (object) {
                this.listeners.addElement(iPropsChangeListener);
            }
        }
        return bl;
    }

    public void append(String string, String string2) {
        Object object = this.container.getProperty(string);
        if (object instanceof String) {
            String string3 = (String)object;
            this.container.setProperty(string, string3 + string2);
        }
    }

    private void appendPropsContainer(StringBuffer stringBuffer, String string, IPropsContainer iPropsContainer, int n) {
        Enumeration enumeration = iPropsContainer.enumerateProps();
        while (enumeration.hasMoreElements()) {
            int n2;
            String string2 = (String)enumeration.nextElement();
            Object object = iPropsContainer.getProperty(string2);
            String string3 = "null";
            if (object != null && (n2 = (string3 = object.getClass().getName()).lastIndexOf(46)) > 0) {
                string3 = string3.substring(n2 + 1);
            }
            this.indent(stringBuffer, n);
            stringBuffer.append(string3);
            stringBuffer.append(' ');
            stringBuffer.append(string2);
            stringBuffer.append(" = ");
            if (object instanceof IPropsContainer) {
                IPropsContainer iPropsContainer2 = (IPropsContainer)object;
                if (object instanceof VectorPropsContainer) {
                    stringBuffer.append(" (");
                    stringBuffer.append(iPropsContainer2.getProperty("size"));
                    stringBuffer.append(" elements)");
                }
                stringBuffer.append('\n');
                this.indent(stringBuffer, n);
                stringBuffer.append("{\n");
                this.appendPropsContainer(stringBuffer, string2, iPropsContainer2, n + 1);
                this.indent(stringBuffer, n);
                stringBuffer.append("}\n");
                continue;
            }
            stringBuffer.append('\"');
            stringBuffer.append(object);
            stringBuffer.append("\";\n");
        }
    }

    public boolean copy(Props props, String string) {
        Object object = props.container.getProperty(string);
        if (object == null) {
            this.container.removeProperty(string);
        } else {
            this.container.setProperty(string, object);
        }
        if (string != null) {
            this.notifyPropsChanged(string);
        }
        return object != null;
    }

    public void copyFrom(Props props) {
        this.suspendNotify();
        Enumeration enumeration = props.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            this.setProperty((String)enumeration.nextElement(), props);
        }
        this.resumeNotify();
    }

    public void copyTo(Props props) {
        props.suspendNotify();
        Enumeration enumeration = this.container.enumerateProps();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            props.setProperty(string, this.container.getProperty(string));
        }
        props.resumeNotify();
    }

    public void decrementInteger(String string) {
        int n = this.getInteger(string);
        this.setInteger(string, n - 1);
    }

    public void dump() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append(" = \"");
            stringBuffer.append(this.getString(string));
            stringBuffer.append("\"\n");
        }
        System.out.println(stringBuffer.toString());
    }

    public Enumeration enumerateKeys() {
        return this.container.enumerateProps();
    }

    public void enableListeners() {
        if (this.listeners == null) {
            this.listeners = new Vector();
            this.changedProps = new Vector();
            this.listenerSync = new Object();
        }
    }

    public String format(String string) throws PropsException {
        String string2 = null;
        Object[] objectArray = null;
        try {
            String string3;
            Vector<String> vector = new Vector<String>();
            int n = string.indexOf(123);
            while (n >= 0 && (string3 = this.getNextKey(string, n + 1)) != null) {
                if (!vector.contains(string3)) {
                    vector.add(string3);
                }
                n = string.indexOf(123, n + 1);
            }
            int n2 = vector.size();
            objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                String string4 = (String)vector.get(i);
                Object object = this.getProperty(string4);
                if (object == null) {
                    object = "";
                }
                objectArray[i] = object;
                String string5 = "\\{" + string4;
                String string6 = "\\{" + Integer.toString(i);
                string = string.replaceAll(string5, string6);
            }
            string2 = MessageFormat.format(string, objectArray);
        }
        catch (Exception exception) {
            String string7 = "Could not format pattern (" + exception.toString() + ")\n" + string;
            throw new PropsException(string7, exception);
        }
        return string2;
    }

    public boolean getBoolean(String string) {
        Object object = this.getProperty(string);
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                String string2 = object.toString();
                return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase("T");
            }
        }
        return false;
    }

    public byte[] getByteArray(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object instanceof String) {
                return ((String)object).getBytes();
            }
            return object.toString().getBytes();
        }
        return new byte[0];
    }

    public char getCharacter(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            if (object instanceof String) {
                return ((String)object).charAt(0);
            }
        }
        return '\u0000';
    }

    public Date getDate(String string) {
        Object object = this.container.getProperty(string);
        try {
            if (object != null) {
                if (object instanceof Date) {
                    return (Date)object;
                }
                if (object instanceof String) {
                    return ISO8601_DATEFORMAT.parse((String)object);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public Date getDate(String string, DateFormat dateFormat) {
        Object object = this.container.getProperty(string);
        try {
            if (object != null) {
                if (object instanceof Date) {
                    return (Date)object;
                }
                if (object instanceof String) {
                    return dateFormat.parse((String)object);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public String getDateString(String string, DateFormat dateFormat) {
        Object object = this.container.getProperty(string);
        if (object != null && object instanceof Date) {
            return dateFormat.format((Date)object);
        }
        return new String();
    }

    public double getDouble(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue();
            }
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue();
            }
            if (object instanceof String) {
                return Double.valueOf((String)object);
            }
        }
        return 0.0;
    }

    public float getFloat(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
            if (object instanceof Double) {
                return ((Double)object).floatValue();
            }
            if (object instanceof Integer) {
                return ((Integer)object).floatValue();
            }
            if (object instanceof Long) {
                return ((Long)object).floatValue();
            }
            if (object instanceof String) {
                return Float.valueOf((String)object).floatValue();
            }
        }
        return 0.0f;
    }

    public String getHexString(String string) {
        String string2 = new String();
        byte[] byArray = this.getByteArray(string);
        for (int i = 0; i < byArray.length; ++i) {
            string2 = string2 + Integer.toHexString(byArray[i] & 0xFF).toUpperCase();
        }
        return string2;
    }

    public int getInteger(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            if (object instanceof Long) {
                return ((Long)object).intValue();
            }
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            if (object instanceof Double) {
                return ((Double)object).intValue();
            }
        }
        return 0;
    }

    public long getLong(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Integer) {
                return ((Integer)object).longValue();
            }
            if (object instanceof Float) {
                return ((Float)object).longValue();
            }
            if (object instanceof Double) {
                return ((Double)object).longValue();
            }
        }
        return 0L;
    }

    public Vector getKeys() {
        Vector vector = new Vector();
        Enumeration enumeration = this.container.enumerateProps();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    protected String getNextKey(String string, int n) {
        String string2 = null;
        int n2 = string.indexOf(125, n);
        int n3 = string.indexOf(44, n);
        int n4 = -1;
        if (n < n2 && (n2 < n3 || n3 == -1)) {
            n4 = n2;
        } else if (n < n3 && (n3 < n2 || n2 == -1)) {
            n4 = n3;
        }
        if (n4 >= 0) {
            string2 = string.substring(n, n4);
        }
        return string2;
    }

    public Object getProperty(String string) {
        return this.container.getProperty(string);
    }

    public Object getProperty(String string, PropsSchema propsSchema) throws PropsException {
        Object object = this.container.getProperty(string);
        try {
            Props props = propsSchema.getFieldSchema(string);
            if (props != null) {
                String string2 = props.getString("type");
                if (string2.equals("date") || string2.equals("time")) {
                    if (!(object instanceof Date)) {
                        String string3 = props.getString("style");
                        String string4 = "{0," + string2 + "," + string3 + "}";
                        MessageFormat messageFormat = new MessageFormat(string4);
                        Object[] objectArray = messageFormat.parse(object.toString());
                        object = objectArray[0];
                    }
                } else if (string2.equals("boolean")) {
                    if (!(object instanceof Boolean)) {
                        object = new Boolean(this.getBoolean(string));
                    }
                } else if (string2.equals("integer")) {
                    if (!(object instanceof Integer)) {
                        object = new Integer(this.getInteger(string));
                    }
                } else if (string2.equals("number") || string2.equals("choice")) {
                    String string5 = props.getString("style");
                    String string6 = "{0," + string2 + "," + string5 + "}";
                    MessageFormat messageFormat = new MessageFormat(string6);
                    Object[] objectArray = messageFormat.parse(object.toString());
                    object = objectArray[0];
                }
            }
        }
        catch (Exception exception) {
            throw new PropsException("Cannot interpret property: " + string + " = \"" + object + "\"");
        }
        return object;
    }

    public IPropsContainer getPropsContainer() {
        return this.container;
    }

    public int getSize(String string) {
        Object object = this.container.getProperty(string);
        if (object == null) {
            return 0;
        }
        if (object instanceof List) {
            return ((List)object).size();
        }
        if (object instanceof VectorPropsContainer) {
            return ((VectorPropsContainer)object).getVector().size();
        }
        return 1;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPropsContainer(stringBuffer, "", this.container, 1);
        return stringBuffer.toString();
    }

    public String getString(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            return object.toString();
        }
        return "";
    }

    public Vector getTokens(String string) {
        return this.getTokens(string, ";,\r\n");
    }

    public Vector getTokens(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        String string3 = this.getString(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        return vector;
    }

    public String getTrimmedString(String string) {
        return this.getString(string).trim();
    }

    public Vector getVector(String string) {
        Object object = this.container.getProperty(string);
        if (object != null) {
            if (object instanceof Vector) {
                return (Vector)object;
            }
            if (object instanceof VectorPropsContainer) {
                return ((VectorPropsContainer)object).getVector();
            }
            if (object instanceof IPropsContainer) {
                IPropsContainer iPropsContainer = (IPropsContainer)object;
                Vector<IPropsContainer> vector = new Vector<IPropsContainer>();
                vector.add(iPropsContainer);
                return vector;
            }
            Vector<Object> vector = new Vector<Object>();
            vector.add(object);
            return vector;
        }
        return new Vector();
    }

    public boolean hasProperty(String string) {
        return this.container.getProperty(string) != null;
    }

    public void incrementInteger(String string) {
        int n = this.getInteger(string);
        this.setInteger(string, n + 1);
    }

    private void indent(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("   ");
        }
    }

    public String insertProps(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(60, n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n, string.length()));
                break;
            }
            if (n < n2) {
                stringBuffer.append(string.substring(n, n2));
                n = n2;
            }
            if ((n2 = string.indexOf(62, n)) == -1) {
                stringBuffer.append(string.substring(n, string.length()));
                break;
            }
            String string2 = string.substring(n + 1, n2);
            if (this.hasProperty(string2)) {
                stringBuffer.append(this.getString(string2));
            } else {
                stringBuffer.append("<" + string2 + ">");
            }
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPropsChanged(String string) {
        if (this.listeners == null) {
            return;
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
        Object object = this.listenerSync;
        synchronized (object) {
            this.changedProps.addElement(string);
        }
        if (this.suspendNotify == 0) {
            this.notifyPropsChangedIgnore(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPropsChangedIgnore(IPropsChangeListener iPropsChangeListener) {
        Object[] objectArray;
        if (this.listeners == null) {
            return;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Object object = this.listenerSync;
        synchronized (object) {
            if (this.changedProps.size() > 0) {
                objectArray = this.changedProps.elements();
                while (objectArray.hasMoreElements()) {
                    vector2.addElement(objectArray.nextElement());
                }
                this.changedProps.removeAllElements();
            }
        }
        object = this.listenerSync;
        synchronized (object) {
            objectArray = this.listeners.elements();
            while (objectArray.hasMoreElements()) {
                vector.addElement(objectArray.nextElement());
            }
        }
        int n = vector2.size();
        if (n > 0) {
            objectArray = new String[n];
            vector2.copyInto(objectArray);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                IPropsChangeListener iPropsChangeListener2 = (IPropsChangeListener)enumeration.nextElement();
                if (iPropsChangeListener2 == iPropsChangeListener) continue;
                iPropsChangeListener2.propsChanged(this, (String[])objectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPropsChangedIgnore(String string, IPropsChangeListener iPropsChangeListener) {
        if (this.listeners == null) {
            return;
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
        Object object = this.listenerSync;
        synchronized (object) {
            this.changedProps.addElement(string);
        }
        if (this.suspendNotify == 0) {
            this.notifyPropsChangedIgnore(iPropsChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPropsChangedIgnore(String[] stringArray, IPropsChangeListener iPropsChangeListener) {
        if (this.listeners == null) {
            return;
        }
        if (stringArray == null) {
            throw new NullPointerException("changedKeys is null");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.listenerSync;
            synchronized (object) {
                this.changedProps.addElement(stringArray[i]);
                continue;
            }
        }
        if (this.suspendNotify == 0) {
            this.notifyPropsChangedIgnore(iPropsChangeListener);
        }
    }

    public void parse(String string, String string2) throws ParseException {
        Object object;
        String string3;
        Vector<String> vector = new Vector<String>();
        int n = string2.indexOf(123);
        while (n >= 0 && (string3 = this.getNextKey(string2, n + 1)) != null) {
            if (!vector.contains(string3)) {
                vector.add(string3);
            }
            n = string2.indexOf(123, n + 1);
        }
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object = "\\{" + (String)vector.get(i);
            String string4 = "\\{" + Integer.toString(i);
            string2 = string2.replaceAll((String)object, string4);
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        object = messageFormat.parse(string);
        for (int i = 0; i < ((Object[])object).length; ++i) {
            this.setProperty((String)vector.get(i), object[i]);
        }
    }

    public boolean propertyMatchesRegEx(String string, String string2) {
        String string3 = this.getString(string);
        return string3.matches(string2);
    }

    public boolean regExPropertyMatches(String string, String string2) {
        String string3 = this.getString(string);
        return string2.matches(string3);
    }

    public void removeAll() {
        Enumeration enumeration = this.container.enumerateProps();
        while (enumeration.hasMoreElements()) {
            this.container.removeProperty((String)enumeration.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(IPropsChangeListener iPropsChangeListener) {
        boolean bl = false;
        if (this.listeners != null) {
            Object object = this.listenerSync;
            synchronized (object) {
                bl = this.listeners.removeElement(iPropsChangeListener);
            }
        }
        return bl;
    }

    public boolean removeProperty(String string) {
        boolean bl = this.container.removeProperty(string);
        this.notifyPropsChanged(string);
        return bl;
    }

    public void resumeNotify() {
        if (this.suspendNotify > 0) {
            --this.suspendNotify;
            if (this.suspendNotify == 0) {
                this.notifyPropsChangedIgnore(null);
            }
        }
    }

    public void set(String string, Object object) {
        this.setProperty(string, object);
    }

    public void setBoolean(String string, boolean bl) {
        this.container.setProperty(string, new Boolean(bl));
        this.notifyPropsChanged(string);
    }

    public void setCharacter(String string, char c) {
        this.container.setProperty(string, new Character(c));
        this.notifyPropsChanged(string);
    }

    public void setDefault(String string, Object object) {
        Object object2 = this.container.getProperty(string);
        if (object2 == null) {
            this.setProperty(string, object);
        }
    }

    public void setDouble(String string, double d) {
        this.container.setProperty(string, new Double(d));
        this.notifyPropsChanged(string);
    }

    public void setFloat(String string, float f) {
        this.container.setProperty(string, new Float(f));
        this.notifyPropsChanged(string);
    }

    public void setInteger(String string, int n) {
        this.container.setProperty(string, new Integer(n));
        this.notifyPropsChanged(string);
    }

    public void setLong(String string, long l) {
        this.container.setProperty(string, new Long(l));
        this.notifyPropsChanged(string);
    }

    public void setProperty(String string, Object object) {
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            this.container.removeProperty(string);
        } else {
            this.container.setProperty(string, object);
        }
        this.notifyPropsChanged(string);
    }

    public void setProperty(String string, Props props) {
        this.setProperty(string, props.getProperty(string));
    }

    public void setProperty(String string, Props props, String string2) {
        this.setProperty(string, props.getProperty(string2));
    }

    public void setPropsContainer(IPropsContainer iPropsContainer) {
        this.container = iPropsContainer;
    }

    public void suspendNotify() {
        ++this.suspendNotify;
    }

    public String toString() {
        return this.getString();
    }

    public static Props loadProps(String string) {
        Props props = new Props();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            File file = new File(string);
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("=");
                if (n == -1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1, string2.length()).trim();
                props.setProperty(string3, string4);
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Properties could not be loaded.");
            System.err.println(exception);
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return props;
    }

    public static Props readFromFile(String string) {
        Props props = new Props();
        FileInputStream fileInputStream = null;
        try {
            File file = new File(string);
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            IPropsContainer iPropsContainer = (IPropsContainer)ObjectSerializer.unserialize(byArray);
            props.setPropsContainer(iPropsContainer);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception2) {
                System.err.println(exception2);
            }
        }
        return props;
    }

    public static boolean saveProps(String string, Props props) {
        BufferedWriter bufferedWriter = null;
        try {
            String string2;
            File file = new File(string);
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            Vector<Pair> vector = new Vector<Pair>();
            Enumeration enumeration = props.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                vector.addElement(new Pair(string2, props.getString(string2)));
            }
            enumeration = StringTools.pairSort(vector).elements();
            while (enumeration.hasMoreElements()) {
                Pair pair = (Pair)enumeration.nextElement();
                string2 = (String)pair.first();
                String string3 = (String)pair.second();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append(string3.trim());
                stringBuffer.append(EOL);
                bufferedWriter.write(stringBuffer.toString(), 0, stringBuffer.length());
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public static void writeToFile(String string, Props props) {
        block5: {
            FileOutputStream fileOutputStream = null;
            try {
                byte[] byArray = ObjectSerializer.serialize(props.getPropsContainer());
                if (byArray != null) {
                    fileOutputStream = new FileOutputStream(string);
                    fileOutputStream.write(byArray);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                if (fileOutputStream == null) break block5;
                System.err.println(exception);
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }
}

