/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.httpd;

import com.cometway.props.Props;
import com.cometway.util.IntegerPair;
import com.cometway.util.jGrep;
import com.cometway.xml.XML;
import com.cometway.xml.XMLParser;
import com.cometway.xml.XMLParserException;
import com.cometway.xml.XMLToken;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class HTMLStringTools {
    protected static final String EOL = System.getProperty("line.separator");

    public static String extractIMGTag(String string, Perl5Util perl5Util) {
        IntegerPair integerPair = null;
        integerPair = perl5Util == null ? jGrep.indecesOf("<[\\s]*img[^>]*>", string, true) : jGrep.indecesOf("<[\\s]*img[^>]*>", string, true, perl5Util);
        if (integerPair == null) {
            return "";
        }
        return string.substring(integerPair.firstInt(), integerPair.secondInt());
    }

    public static String extractIMGTag(String string) {
        return HTMLStringTools.extractIMGTag(string, null);
    }

    public static String removeHTMLTags(String string) {
        return HTMLStringTools.removeHTMLTags(string, null);
    }

    public static String removeHTMLTags(String string, Perl5Util perl5Util) {
        if (perl5Util == null) {
            return jGrep.grepAndReplaceText("<[A-Za-z\\s]*[^>]*>", "", string, true);
        }
        return jGrep.grepAndReplaceText("<[A-Za-z\\s]*[^>]*>", "", string, true, perl5Util);
    }

    public static String removeFormTags(String string) {
        String string2 = jGrep.grepAndReplaceText("</*input[^>]*>", "", string, true);
        string2 = jGrep.grepAndReplaceText("</*select[^>]*>", "", string2, true);
        string2 = jGrep.grepAndReplaceText("</*option[^>]*>", "", string2, true);
        string2 = jGrep.grepAndReplaceText("</*form[^>]*>", "<BR>", string2, true);
        return string2;
    }

    public static String removeFormTags(String string, Perl5Util perl5Util) {
        String string2 = jGrep.grepAndReplaceText("</*input[^>]*>", "", string, true, perl5Util);
        string2 = jGrep.grepAndReplaceText("</*select[^>]*>", "", string2, true, perl5Util);
        string2 = jGrep.grepAndReplaceText("</*option[^>]*>", "", string2, true, perl5Util);
        string2 = jGrep.grepAndReplaceText("</*form[^>]*>", "<BR>", string2, true, perl5Util);
        return string2;
    }

    public static String removeTableTags(String string) {
        String string2 = jGrep.grepAndReplaceText("</*table[^>]*>", "<BR>", string, true);
        string2 = jGrep.grepAndReplaceText("</*t[rdhc][^>]*>", "<BR>", string2, true);
        string2 = jGrep.grepAndReplaceText("</*span[^>]*>", "", string2, true);
        return string2;
    }

    public static String removeTableTags(String string, Perl5Util perl5Util) {
        String string2 = jGrep.grepAndReplaceText("</*table[^>]*>", "<BR>", string, true, perl5Util);
        string2 = jGrep.grepAndReplaceText("</*t[drhc][^>]*>", "<BR>", string2, true, perl5Util);
        string2 = jGrep.grepAndReplaceText("</*span[^>]*>", "", string2, true, perl5Util);
        return string2;
    }

    public static String removeHRTags(String string) {
        return jGrep.grepAndReplaceText("<hr[^>]*>", "<BR>", string, true);
    }

    public static String removeHRTags(String string, Perl5Util perl5Util) {
        return jGrep.grepAndReplaceText("<hr[^>]*>", "<BR>", string, true, perl5Util);
    }

    public static String removeListTags(String string) {
        String string2 = jGrep.grepAndReplaceText("</*[oud]l[^>]*>", "<BR>", string, true);
        string2 = jGrep.grepAndReplaceText("</*li[^>]*>", "<BR>", string2, true);
        string2 = jGrep.grepAndReplaceText("</*d[td][^>]*>", "<BR>", string2, true);
        return string2;
    }

    public static String removeListTags(String string, Perl5Util perl5Util) {
        String string2 = jGrep.grepAndReplaceText("</*[dou]l[^>]*>", "<BR>", string, true, perl5Util);
        string2 = jGrep.grepAndReplaceText("</*li[^>]*>", "<BR>", string2, true, perl5Util);
        string2 = jGrep.grepAndReplaceText("</*d[dt][^>]*>", "<BR>", string2, true, perl5Util);
        return string2;
    }

    public static String extractURL(String string) {
        String string2 = string.toLowerCase();
        int n = string2.indexOf("http");
        if (n == -1) {
            n = string.length();
        }
        if (string2.indexOf("ftp") != -1 && n > string2.indexOf("ftp")) {
            n = string2.indexOf("ftp");
        }
        if (string2.indexOf("file") != -1 && n > string2.indexOf("file")) {
            n = string2.indexOf("file");
        }
        if (string2.indexOf("news") != -1 && n > string2.indexOf("news")) {
            n = string2.indexOf("news");
        }
        if (string2.indexOf("telnet") != -1 && n > string2.indexOf("telnet")) {
            n = string2.indexOf("telnet");
        }
        if (string2.indexOf("mail") != -1 && n > string2.indexOf("mail")) {
            n = string2.indexOf("mail");
        }
        if (n == string.length()) {
            return "";
        }
        int n2 = string.indexOf("\"", n);
        if (n2 == -1) {
            n2 = string.length();
        }
        if (string2.indexOf(" ", n) != -1 && n2 > string2.indexOf(" ", n)) {
            n2 = string2.indexOf(" ", n);
        }
        if (string2.indexOf(">", n) != -1 && n2 > string2.indexOf(">", n)) {
            n2 = string2.indexOf(">", n);
        }
        if (string2.indexOf("'", n) != -1 && n2 > string2.indexOf("'", n)) {
            n2 = string2.indexOf("'", n);
        }
        if (string2.indexOf("\n", n) != -1 && n2 > string2.indexOf("\n", n)) {
            n2 = string2.indexOf("\n", n);
        }
        if (string2.indexOf(";", n) != -1 && n2 > string2.indexOf(";", n)) {
            n2 = string2.indexOf(";", n);
        }
        return string.substring(n, n2);
    }

    public static String completeURLs(String string, String string2) {
        String string3 = "";
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string5;
            int n;
            String string6;
            int n2 = string2.lastIndexOf("/");
            int n3 = string2.indexOf("://");
            System.gc();
            if (n2 == -1 || n3 == -1) {
                return string;
            }
            string4 = n3 + 2 == n2 && string2.length() > 10 ? string2 : (string2.indexOf("?", n2) == -1 ? (string2.indexOf(".", n2) == -1 && string2.substring(n2 + 1).trim().length() > 0 ? string2 : string2.substring(0, n2)) : (string2.indexOf("?", n3) != -1 ? (n3 + 2 == (n2 = (string6 = string2.substring(0, n = string2.indexOf("?", n3))).lastIndexOf("/")) && string6.length() > 10 ? string6 : string6.substring(0, n2)) : string2));
            if (n3 != -1) {
                n = string2.indexOf("/", n3 + 3);
                string3 = n == -1 ? string2 : string2.substring(0, n);
            }
            if (string3.charAt(string3.length() - 1) == '/') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (string4.charAt(string4.length() - 1) == '/') {
                string4 = string4.substring(0, string4.length() - 1);
            }
            String string7 = string.toLowerCase();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            String string8 = "";
            n4 = string7.indexOf("href");
            while (n4 > -1 && string7.length() > 0) {
                string5 = "";
                n6 = string7.indexOf("=", n4);
                if (n6 != -1) {
                    stringBuffer.append(string.substring(0, n6 + 1));
                    string = string.substring(n6 + 1);
                    string7 = string7.substring(n6 + 1);
                    for (n4 = 0; n4 != string.length() && Character.isWhitespace(string7.charAt(n4)); ++n4) {
                    }
                    if (string7.charAt(n4) == '\"') {
                        string5 = "\"";
                        n5 = string7.indexOf("\"", n4 + 1);
                        string8 = string.substring(n4 + 1, n5);
                        string = string.substring(n5 + 1);
                        string7 = string7.substring(n5 + 1);
                    } else if (string7.charAt(n4) == '\'') {
                        string5 = "'";
                        n5 = string7.indexOf("'", n4 + 1);
                        string8 = string.substring(n4 + 1, n5);
                        string = string.substring(n5 + 1);
                        string7 = string7.substring(n5 + 1);
                    } else {
                        n5 = string7.indexOf(" ", n4 + 1);
                        n6 = string7.indexOf(">", n4 + 1);
                        if (n5 == -1) {
                            n5 = string7.length();
                        }
                        if (n5 > n6) {
                            n5 = n6;
                        }
                        string8 = string.substring(n4, n5);
                        string = string.substring(n5);
                        string7 = string7.substring(n5);
                    }
                    if (!(string8.startsWith("http://") || string8.startsWith("mailto:") || string8.startsWith("ftp:"))) {
                        if (string8.startsWith("/")) {
                            stringBuffer.append(string5 + string3 + string8 + string5);
                        } else {
                            stringBuffer.append(string5 + string4 + "/" + string8 + string5);
                        }
                    } else {
                        stringBuffer.append(string5 + string8 + string5);
                    }
                } else {
                    stringBuffer.append(string.substring(0, 1));
                    string = string.substring(1);
                    string7 = string7.substring(1);
                }
                n4 = string7.indexOf("href");
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
            string7 = string.toLowerCase();
            stringBuffer = new StringBuffer();
            n4 = string7.indexOf("img ");
            while (n4 > -1 && string7.length() > 0) {
                string5 = "";
                n6 = string7.indexOf("src", n4);
                if (n6 != -1) {
                    if ((n6 = string7.indexOf("=", n6)) != -1) {
                        stringBuffer.append(string.substring(0, n6 + 1));
                        string = string.substring(n6 + 1);
                        string7 = string7.substring(n6 + 1);
                        for (n4 = 0; n4 != string.length() && Character.isWhitespace(string7.charAt(n4)); ++n4) {
                        }
                        if (string7.charAt(n4) == '\"') {
                            string5 = "\"";
                            n5 = string7.indexOf("\"", n4 + 1);
                            string8 = string.substring(n4 + 1, n5);
                            string = string.substring(n5 + 1);
                            try {
                                string7 = string7.substring(n5 + 1);
                            }
                            catch (Exception exception) {
                                System.out.println("DATA = " + string);
                                System.out.println("LDATA = " + string7);
                            }
                        } else if (string7.charAt(n4) == '\'') {
                            string5 = "'";
                            n5 = string7.indexOf("'", n4 + 1);
                            string8 = string.substring(n4 + 1, n5);
                            string = string.substring(n5 + 1);
                            string7 = string7.substring(n5 + 1);
                        } else {
                            n5 = string7.indexOf(" ", n4 + 1);
                            if (n5 > (n6 = string7.indexOf(">", n4 + 1))) {
                                n5 = n6;
                            }
                            string8 = string.substring(n4, n5);
                            string = string.substring(n5);
                            string7 = string7.substring(n5);
                        }
                        if (!(string8.startsWith("http://") || string8.startsWith("mailto:") || string8.startsWith("ftp:"))) {
                            if (string8.startsWith("/")) {
                                stringBuffer.append(string5 + string3 + string8 + string5);
                            } else {
                                stringBuffer.append(string5 + string4 + "/" + string8 + string5);
                            }
                        } else {
                            stringBuffer.append(string5 + string8 + string5);
                        }
                    } else {
                        stringBuffer.append(string.substring(0, 1));
                        string = string.substring(1);
                        string7 = string7.substring(1);
                    }
                } else {
                    stringBuffer.append(string.substring(0, 1));
                    string = string.substring(1);
                    string7 = string7.substring(1);
                }
                n4 = string7.indexOf("img ");
            }
            stringBuffer.append(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        return HTMLStringTools.encode(string, false, false);
    }

    public static String encode(String string, boolean bl, boolean bl2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[string.length()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = string.charAt(n);
        }
        if (bl) {
            for (n = 0; n < nArray.length; ++n) {
                stringBuffer.append("%");
                stringBuffer.append(HTMLStringTools.intToHex(nArray[n]));
            }
        } else {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 42 || nArray[n] == 45 || nArray[n] == 46 || nArray[n] >= 48 && nArray[n] <= 57 || nArray[n] >= 64 && nArray[n] <= 90 || nArray[n] == 95 || nArray[n] >= 97 && nArray[n] <= 122) {
                    stringBuffer.append(string.charAt(n));
                    continue;
                }
                if (nArray[n] == 47) {
                    if (bl2) {
                        stringBuffer.append("%");
                        stringBuffer.append(HTMLStringTools.intToHex(nArray[n]));
                        continue;
                    }
                    stringBuffer.append(string.charAt(n));
                    continue;
                }
                if (nArray[n] == 32) {
                    stringBuffer.append("+");
                    continue;
                }
                stringBuffer.append("%");
                stringBuffer.append(HTMLStringTools.intToHex(nArray[n]));
            }
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                stringBuffer.append(" ");
                continue;
            }
            if (c == '%') {
                stringBuffer.append((char)HTMLStringTools.hexToInt(string.substring(i + 1, i + 3)));
                i += 2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected static int hexToInt(String string) {
        if (string.length() > 2 || string.length() == 0) {
            return -1;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        int n = 0;
        int n2 = 0;
        if (c == '0') {
            n = 0;
        } else if (c == '1') {
            n = 1;
        } else if (c == '2') {
            n = 2;
        } else if (c == '3') {
            n = 3;
        } else if (c == '4') {
            n = 4;
        } else if (c == '5') {
            n = 5;
        } else if (c == '6') {
            n = 6;
        } else if (c == '7') {
            n = 7;
        } else if (c == '8') {
            n = 8;
        } else if (c == '9') {
            n = 9;
        } else if (c == 'A' || c == 'a') {
            n = 10;
        } else if (c == 'B' || c == 'b') {
            n = 11;
        } else if (c == 'C' || c == 'c') {
            n = 12;
        } else if (c == 'D' || c == 'd') {
            n = 13;
        } else if (c == 'E' || c == 'e') {
            n = 14;
        } else if (c == 'F' || c == 'f') {
            n = 15;
        }
        if (c2 == '0') {
            n2 = 0;
        } else if (c2 == '1') {
            n2 = 1;
        } else if (c2 == '2') {
            n2 = 2;
        } else if (c2 == '3') {
            n2 = 3;
        } else if (c2 == '4') {
            n2 = 4;
        } else if (c2 == '5') {
            n2 = 5;
        } else if (c2 == '6') {
            n2 = 6;
        } else if (c2 == '7') {
            n2 = 7;
        } else if (c2 == '8') {
            n2 = 8;
        } else if (c2 == '9') {
            n2 = 9;
        } else if (c2 == 'A' || c2 == 'a') {
            n2 = 10;
        } else if (c2 == 'B' || c2 == 'b') {
            n2 = 11;
        } else if (c2 == 'C' || c2 == 'c') {
            n2 = 12;
        } else if (c2 == 'D' || c2 == 'd') {
            n2 = 13;
        } else if (c2 == 'E' || c2 == 'e') {
            n2 = 14;
        } else if (c2 == 'F' || c2 == 'f') {
            n2 = 15;
        }
        return n * 16 + n2;
    }

    protected static String intToHex(int n) {
        String string = "";
        int n2 = n % 16;
        int n3 = n / 16;
        if (n3 < 10) {
            string = string + n3;
        } else if (n3 == 10) {
            string = string + "A";
        } else if (n3 == 11) {
            string = string + "B";
        } else if (n3 == 12) {
            string = string + "C";
        } else if (n3 == 13) {
            string = string + "D";
        } else if (n3 == 14) {
            string = string + "E";
        } else if (n3 == 15) {
            string = string + "F";
        }
        if (n2 < 10) {
            string = string + n2;
        } else if (n2 == 10) {
            string = string + "A";
        } else if (n2 == 11) {
            string = string + "B";
        } else if (n2 == 12) {
            string = string + "C";
        } else if (n2 == 13) {
            string = string + "D";
        } else if (n2 == 14) {
            string = string + "E";
        } else if (n2 == 15) {
            string = string + "F";
        }
        return string;
    }

    public static String convertHTMLToPlainText(String string) {
        Object object;
        if (string.trim().length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        XMLParser xMLParser = new XMLParser(string);
        try {
            object = xMLParser.nextToken();
            while (object != null) {
                if (((XMLToken)object).data.equals("<OL>") || ((XMLToken)object).data.equals("<UL>")) {
                    HTMLStringTools.convertHTMLListToPlainText((XMLToken)object, xMLParser, stringBuffer, 0);
                    stringBuffer.append(EOL);
                } else {
                    HTMLStringTools.convertHTMLObjectToPlainText((XMLToken)object, xMLParser, stringBuffer);
                }
                object = xMLParser.nextToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = stringBuffer.toString();
        String string2 = EOL + EOL + EOL;
        while (((String)object).indexOf(string2) != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf(string2)) + EOL + EOL + ((String)object).substring(((String)object).indexOf(string2) + string2.length());
        }
        while (((String)object).indexOf("  ") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("  ")) + ((String)object).substring(((String)object).indexOf("  ") + 1);
        }
        while (((String)object).indexOf(EOL + " ") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf(EOL + " ") + EOL.length()) + ((String)object).substring(((String)object).indexOf(EOL + " ") + EOL.length() + 1);
        }
        while (((String)object).length() > 0 && ((String)object).charAt(0) == ' ') {
            object = ((String)object).substring(1);
        }
        while (((String)object).indexOf("* .") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("* .")) + "*." + ((String)object).substring(((String)object).indexOf("* .") + 3);
        }
        while (((String)object).indexOf("* ,") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("* ,")) + "*," + ((String)object).substring(((String)object).indexOf("* ,") + 3);
        }
        while (((String)object).indexOf("* ?") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("* ?")) + "*?" + ((String)object).substring(((String)object).indexOf("* ?") + 3);
        }
        while (((String)object).indexOf("* !") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("* !")) + "*!" + ((String)object).substring(((String)object).indexOf("* !") + 3);
        }
        while (((String)object).indexOf("\" .") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("\" .")) + "\"." + ((String)object).substring(((String)object).indexOf("\" .") + 3);
        }
        while (((String)object).indexOf("\" ,") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("\" ,")) + "\"," + ((String)object).substring(((String)object).indexOf("\" ,") + 3);
        }
        while (((String)object).indexOf("\" ?") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("\" ?")) + "\"?" + ((String)object).substring(((String)object).indexOf("\" ?") + 3);
        }
        while (((String)object).indexOf("\" !") != -1) {
            object = ((String)object).substring(0, ((String)object).indexOf("\" !")) + "\"!" + ((String)object).substring(((String)object).indexOf("\" !") + 3);
        }
        return object;
    }

    protected static void convertHTMLListToPlainText(XMLToken xMLToken, XMLParser xMLParser, StringBuffer stringBuffer, int n) throws XMLParserException {
        int n2;
        String string = "";
        if (xMLToken.data.equals("<UL>")) {
            for (n2 = 0; n2 < n + 1; ++n2) {
                string = string + "-";
            }
        } else {
            for (n2 = 0; n2 < n + 1; ++n2) {
                string = string + "#";
            }
        }
        string = string + " ";
        xMLToken = xMLParser.nextToken();
        while (xMLToken != null && !xMLToken.data.equals("</UL>") && !xMLToken.data.equals("</OL>")) {
            if (xMLToken.data.equals("<LI>")) {
                xMLToken = xMLParser.nextToken();
                stringBuffer.append(string);
                while (xMLToken != null && !xMLToken.data.equals("<LI>")) {
                    if (xMLToken.data.equals("<OL>") || xMLToken.data.equals("<UL>")) {
                        if (stringBuffer.lastIndexOf(EOL) != stringBuffer.length() - EOL.length()) {
                            stringBuffer.append(EOL);
                        }
                        HTMLStringTools.convertHTMLListToPlainText(xMLToken, xMLParser, stringBuffer, n + 1);
                        xMLToken = xMLParser.nextToken();
                        continue;
                    }
                    HTMLStringTools.convertHTMLObjectToPlainText(xMLToken, xMLParser, stringBuffer);
                    if (xMLToken.data.equals("<LI>") || xMLToken.data.equals("</OL>") || xMLToken.data.equals("</UL>")) break;
                    xMLToken = xMLParser.nextToken();
                }
                if (xMLToken.data.equals("</OL>") || xMLToken.data.equals("</UL>")) continue;
                stringBuffer.append(EOL);
                continue;
            }
            xMLToken = xMLParser.nextToken();
        }
        if (n == 0) {
            stringBuffer.append(EOL);
        }
    }

    protected static void convertHTMLObjectToPlainText(XMLToken xMLToken, XMLParser xMLParser, StringBuffer stringBuffer) throws XMLParserException {
        if (xMLToken.data.equals("</P>")) {
            stringBuffer.append(EOL + EOL);
        } else if (xMLToken.data.equals("<B>")) {
            stringBuffer.append(" *");
        } else if (xMLToken.data.equals("</B>")) {
            stringBuffer.append("* ");
        } else if (xMLToken.data.equals("<I>")) {
            stringBuffer.append(" \"");
        } else if (xMLToken.data.equals("</I>")) {
            stringBuffer.append("\" ");
        } else if (xMLToken.data.startsWith("<IMG ")) {
            Props props = xMLToken.getProps();
            String string = props.getString("SRC");
            if (string.length() == 0) {
                string = props.getString("src");
            }
            stringBuffer.append(" [");
            stringBuffer.append(string);
            stringBuffer.append("] ");
        } else if (xMLToken.data.startsWith("<A HREF")) {
            Props props = xMLToken.getProps();
            String string = props.getString("HREF");
            if (string.length() == 0) {
                string = props.getString("href");
            }
            if (string.startsWith("mailto:")) {
                stringBuffer.append(" ");
                stringBuffer.append(string.substring(string.indexOf(":") + 1));
                stringBuffer.append(" ");
            } else {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            while (xMLToken != null && !xMLToken.data.equals("</A>")) {
                xMLToken = xMLParser.nextToken();
            }
        } else if (xMLToken.type == 2) {
            stringBuffer.append(XML.decode(xMLToken.data));
        }
    }

    protected static String convertPlainTextLineToHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.trim().length() == 0) {
            stringBuffer.append("</P>" + EOL + "<P>");
        } else {
            int n;
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) != ' ') continue;
                if (string.substring(n2, n).trim().length() > 0) {
                    vector.addElement(string.substring(n2, n).trim());
                }
                n2 = n;
            }
            if (n > n2) {
                vector.addElement(string.substring(n2, n).trim());
            }
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < vector.size(); ++i) {
                String string2;
                int n3;
                boolean bl3;
                String string3 = (String)vector.elementAt(i);
                if (string3.indexOf("@") > 0 && string3.indexOf("@") != string3.length() - 1) {
                    stringBuffer.append("<A HREF='mailto:");
                    stringBuffer.append(string3);
                    stringBuffer.append("'>");
                    stringBuffer.append(XML.encode(string3));
                    stringBuffer.append("</A> ");
                    continue;
                }
                if (string3.startsWith("[") && string3.charAt(string3.length() - 1) == ']') {
                    string3 = string3.substring(1, string3.length() - 1);
                    stringBuffer.append("<IMG SRC='");
                    stringBuffer.append(string3);
                    stringBuffer.append("'> ");
                    continue;
                }
                if (string3.indexOf(":") > 0 && string3.indexOf(":") < string3.length() - 4) {
                    stringBuffer.append("<A HREF='");
                    stringBuffer.append(string3);
                    stringBuffer.append("' TARGET='_blank'>");
                    stringBuffer.append(XML.encode(string3));
                    stringBuffer.append("</A> ");
                    continue;
                }
                if (string3.startsWith("*") && !string3.equals("*") && !bl) {
                    bl3 = false;
                    for (n3 = i + 1; n3 < vector.size(); ++n3) {
                        string2 = (String)vector.elementAt(i);
                        if (!(string2.lastIndexOf("*") == string2.length() - 1 || string2.lastIndexOf("*") == string2.length() - 1 || string2.length() > 1 && string2.lastIndexOf("*.") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("*,") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("*?") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("*:") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("*;") == string2.length() - 2) && (string2.length() <= 1 || string2.lastIndexOf("*!") != string2.length() - 2)) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) continue;
                    stringBuffer.append("<B>");
                    if (string3.lastIndexOf("*") == string3.length() - 1) {
                        System.out.println(string3);
                        stringBuffer.append(string3.substring(1, string3.length() - 1));
                        stringBuffer.append("</B> ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("*.") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</B>. ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("*,") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</B>, ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("*?") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</B>? ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("*:") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</B>: ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("*;") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</B>; ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("*!") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</B>! ");
                        continue;
                    }
                    bl = true;
                    stringBuffer.append(string3.substring(1));
                    stringBuffer.append(" ");
                    continue;
                }
                if (string3.lastIndexOf("*") == string3.length() - 1 && bl) {
                    stringBuffer.append(string3.substring(0, string3.length() - 1));
                    stringBuffer.append("</B> ");
                    bl = false;
                    continue;
                }
                if (string3.startsWith("\"") && !string3.equals("\"") && !bl && !bl2) {
                    bl3 = false;
                    for (n3 = i + 1; n3 < vector.size(); ++n3) {
                        string2 = (String)vector.elementAt(i);
                        if (!(string2.lastIndexOf("\"") == string2.length() - 1 || string2.lastIndexOf("\"") == string2.length() - 1 || string2.length() > 1 && string2.lastIndexOf("\".") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("\",") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("\"?") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("\":") == string2.length() - 2 || string2.length() > 1 && string2.lastIndexOf("\";") == string2.length() - 2) && (string2.length() <= 1 || string2.lastIndexOf("\"!") != string2.length() - 2)) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) continue;
                    stringBuffer.append("<I>");
                    if (string3.lastIndexOf(34) == string3.length() - 1) {
                        stringBuffer.append(string3.substring(1, string3.length() - 1));
                        stringBuffer.append("</I> ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("\".") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</I>. ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("\",") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</I>, ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("\"?") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</I>? ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("\":") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</I>: ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("\";") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</I>; ");
                        continue;
                    }
                    if (string3.length() > 1 && string3.lastIndexOf("\"!") == string3.length() - 2) {
                        stringBuffer.append(string3.substring(1, string3.length() - 2));
                        stringBuffer.append("</I>! ");
                        continue;
                    }
                    bl2 = true;
                    stringBuffer.append(string3.substring(1));
                    stringBuffer.append(" ");
                    continue;
                }
                if (string3.lastIndexOf(34) == string3.length() - 1 && !bl && bl2) {
                    stringBuffer.append(string3.substring(0, string3.length() - 1));
                    stringBuffer.append("</I> ");
                    bl2 = false;
                    continue;
                }
                if (string3.length() > 1 && string3.lastIndexOf("\".") == string3.length() - 2 && !bl && bl2) {
                    stringBuffer.append(string3.substring(0, string3.length() - 2));
                    stringBuffer.append("</I>. ");
                    bl2 = false;
                    continue;
                }
                if (string3.length() > 1 && string3.lastIndexOf("\",") == string3.length() - 2 && !bl && bl2) {
                    stringBuffer.append(string3.substring(0, string3.length() - 2));
                    stringBuffer.append("</I>, ");
                    bl2 = false;
                    continue;
                }
                if (string3.length() > 1 && string3.lastIndexOf("\"?") == string3.length() - 2 && !bl && bl2) {
                    stringBuffer.append(string3.substring(0, string3.length() - 2));
                    stringBuffer.append("</I>? ");
                    bl2 = false;
                    continue;
                }
                if (string3.length() > 1 && string3.lastIndexOf("\":") == string3.length() - 2 && !bl && bl2) {
                    stringBuffer.append(string3.substring(0, string3.length() - 2));
                    stringBuffer.append("</I>: ");
                    bl2 = false;
                    continue;
                }
                if (string3.length() > 1 && string3.lastIndexOf("\";") == string3.length() - 2 && !bl && bl2) {
                    stringBuffer.append(string3.substring(0, string3.length() - 2));
                    stringBuffer.append("</I>; ");
                    bl2 = false;
                    continue;
                }
                if (string3.length() > 1 && string3.lastIndexOf("\"!") == string3.length() - 2 && !bl && bl2) {
                    stringBuffer.append(string3.substring(0, string3.length() - 2));
                    stringBuffer.append("</I>! ");
                    bl2 = false;
                    continue;
                }
                stringBuffer.append(XML.encode(string3));
                stringBuffer.append(" ");
            }
            if (bl) {
                stringBuffer.append("</B> ");
            } else if (bl2) {
                stringBuffer.append("</I> ");
            }
        }
        return stringBuffer.toString();
    }

    public static String convertPlainTextToHTML(String string) {
        int n;
        if (string.trim().length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '\n') continue;
            vector.addElement(string.substring(n2, n).trim());
            n2 = n;
        }
        if (n > n2) {
            vector.addElement(string.substring(n2, n).trim());
            vector.addElement("");
        }
        if (vector.size() > 0 && (((String)vector.elementAt(0)).startsWith("#") || ((String)vector.elementAt(0)).startsWith("-"))) {
            stringBuffer.append("<P>");
            bl = true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (string2.startsWith("#") || string2.startsWith("-")) {
                boolean bl2 = false;
                if (bl) {
                    stringBuffer.append("</P>" + EOL);
                    bl = false;
                }
                if (string2.startsWith("#")) {
                    bl2 = true;
                    stringBuffer.append("<OL>" + EOL);
                } else {
                    stringBuffer.append("<UL>" + EOL);
                }
                while (string2.startsWith("#") || string2.startsWith("-")) {
                    boolean bl3 = false;
                    if (string2.startsWith("##")) {
                        stringBuffer.append("<OL>" + EOL);
                        while (string2.startsWith("##") || string2.startsWith("--")) {
                            if (string2.startsWith("###")) {
                                stringBuffer.append("<OL>" + EOL);
                                while (string2.startsWith("###")) {
                                    stringBuffer.append("<LI>");
                                    stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2.substring(3)));
                                    stringBuffer.append(EOL);
                                    if (++i >= vector.size()) break;
                                    string2 = (String)vector.elementAt(i);
                                }
                                stringBuffer.append("</OL>" + EOL);
                                continue;
                            }
                            if (string2.startsWith("---")) {
                                stringBuffer.append("<UL>" + EOL);
                                while (string2.startsWith("---")) {
                                    stringBuffer.append("<LI>");
                                    stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2.substring(3)));
                                    stringBuffer.append(EOL);
                                    if (++i >= vector.size()) break;
                                    string2 = (String)vector.elementAt(i);
                                }
                                stringBuffer.append("</UL>" + EOL);
                                continue;
                            }
                            stringBuffer.append("<LI>");
                            stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2.substring(2)));
                            stringBuffer.append(EOL);
                            if (++i >= vector.size()) break;
                            string2 = (String)vector.elementAt(i);
                        }
                        stringBuffer.append("</OL>" + EOL);
                    } else if (string2.startsWith("--")) {
                        stringBuffer.append("<UL>" + EOL);
                        while (string2.startsWith("##") || string2.startsWith("--")) {
                            if (string2.startsWith("###")) {
                                stringBuffer.append("<OL>" + EOL);
                                while (string2.startsWith("###")) {
                                    stringBuffer.append("<LI>");
                                    stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2.substring(3)));
                                    stringBuffer.append(EOL);
                                    if (++i >= vector.size()) break;
                                    string2 = (String)vector.elementAt(i);
                                }
                                stringBuffer.append("</OL>" + EOL);
                                continue;
                            }
                            if (string2.startsWith("---")) {
                                stringBuffer.append("<UL>" + EOL);
                                while (string2.startsWith("---")) {
                                    stringBuffer.append("<LI>");
                                    stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2.substring(3)));
                                    stringBuffer.append(EOL);
                                    if (++i >= vector.size()) break;
                                    string2 = (String)vector.elementAt(i);
                                }
                                stringBuffer.append("</UL>" + EOL);
                                continue;
                            }
                            stringBuffer.append("<LI>");
                            stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2.substring(2)));
                            stringBuffer.append(EOL);
                            if (++i >= vector.size()) break;
                            string2 = (String)vector.elementAt(i);
                        }
                        stringBuffer.append("</UL>" + EOL);
                    }
                    if (bl2 && string2.startsWith("#") || !bl2 && string2.startsWith("-")) {
                        stringBuffer.append("<LI>");
                        stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2.substring(1)));
                        stringBuffer.append(EOL);
                        ++i;
                        while (i < vector.size() && !(string2 = (String)vector.elementAt(i)).startsWith("#") && !string2.startsWith("-") && string2.trim().length() > 0) {
                            stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2));
                            stringBuffer.append(EOL);
                            ++i;
                        }
                        if (i < vector.size()) continue;
                        break;
                    }
                    --i;
                    break;
                }
                if (bl2) {
                    stringBuffer.append("</OL>" + EOL);
                    continue;
                }
                stringBuffer.append("</UL>" + EOL);
                continue;
            }
            if (!bl) {
                stringBuffer.append("<P>");
                bl = true;
            }
            stringBuffer.append(HTMLStringTools.convertPlainTextLineToHTML(string2));
        }
        String string3 = stringBuffer.toString();
        if (string3.lastIndexOf("<P>") > string3.lastIndexOf("</P>")) {
            string3 = string3 + "</P>";
        }
        while (string3.indexOf("<P></P>") != -1) {
            string3 = string3.substring(0, string3.indexOf("<P></P>")) + string3.substring(string3.indexOf("<P></P>") + 7).trim();
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        String string = "NHIS administators have access to the following applications from \nthis page:\n\n- Card Manufacturing Management \nhttps://nhis.cometway.com/content.agent?page_name=Article&name=100\n\n- Employer Management \nhttps://nhis.cometway.com/content.agent?page_name=Article&name=108\n\n- HMO Management \nhttps://nhis.cometway.com/content.agent?page_name=Article&name=121\n\n- Hospital Management \nhttps://nhis.cometway.com/content.agent?page_name=Article&name=133\n\n- Patient Management \nhttps://nhis.cometway.com/content.agent?page_name=Article&name=145\n\n- System Administration \nhttps://nhis.cometway.com/content.agent?page_name=Article&name=149\n";
        String string2 = HTMLStringTools.convertPlainTextToHTML(string);
        System.out.println("\n" + string);
        System.out.println("\n" + string2);
        string2 = HTMLStringTools.convertHTMLToPlainText(string2);
        System.out.println("\n" + string2);
        if (string.equals(string2)) {
            System.out.println("same");
        }
    }
}

