/*
 * Decompiled with CFR 0.152.
 */
package com.cometway.httpd;

import com.cometway.ak.AgentRequest;
import com.cometway.props.Props;
import java.io.IOException;
import java.util.Enumeration;

public class HTMLFormWriter {
    private StringBuffer buffer;
    private AgentRequest agentRequest;

    public HTMLFormWriter(AgentRequest agentRequest) {
        this.agentRequest = agentRequest;
    }

    public HTMLFormWriter(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }

    public void print(int n) throws IOException {
        this.print(new Integer(n).toString());
    }

    public void print(String string) throws IOException {
        if (this.agentRequest != null) {
            this.agentRequest.print(string);
        } else {
            this.buffer.append(string);
        }
    }

    public void println(int n) throws IOException {
        this.println(new Integer(n).toString());
    }

    public void println(String string) throws IOException {
        if (this.agentRequest != null) {
            this.agentRequest.println(string);
        } else {
            this.buffer.append(string + "\n");
        }
    }

    public void writeCaption(String string) throws IOException {
        this.println("<TR><TD ALIGN=CENTER COLSPAN=2>" + string + "</TD></TR>");
    }

    public void writeCheckbox(String string, String string2, boolean bl) throws IOException {
        this.println("<TR><TD ALIGN=RIGHT VALIGN=BOTTOM>" + string + ":</TD>");
        if (bl) {
            this.println("<TD VALIGN=BOTTOM><INPUT type=CHECKBOX name=\"" + this.encode(string2) + "\" CHECKED></TD>\n</TR>");
        } else {
            this.println("<TD VALIGN=BOTTOM><INPUT type=CHECKBOX name=\"" + this.encode(string2) + "\"></TD>\n</TR>");
        }
    }

    public void writeCheckbox(String string, String string2, boolean bl, String string3) throws IOException {
        this.println("<TR><TD ALIGN=RIGHT VALIGN=BOTTOM>" + string + ":</TD>");
        if (bl) {
            this.println("<TD VALIGN=BOTTOM><INPUT type=CHECKBOX name=\"" + this.encode(string2) + "\" CHECKED></TD>\n</TR>");
        } else {
            this.println("<TD VALIGN=BOTTOM><INPUT type=CHECKBOX name=\"" + this.encode(string2) + "\"></TD>\n</TR>");
        }
    }

    public void writeFooter() throws IOException {
        this.println("</TABLE>\n</FORM>");
    }

    public void writeHeader(String string) throws IOException {
        this.println("<FORM method=POST action=" + string + ">");
        this.println("<TABLE WIDTH=100%>");
    }

    public void writeHeader(String string, Props props) throws IOException {
        this.writeHeader(string);
        this.writeLoginFields(props);
    }

    public void writeHelp(String string) throws IOException {
        this.println("<TR><TD></TD><TD>" + string + "</TD></TR>");
    }

    public void writeSpace() throws IOException {
        this.println("<TR><TD COLSPAN=2>&nbsp;</TD></TR>");
    }

    public void writeField(String string, String string2, int n) throws IOException {
        this.writeField(string, string2, "", n);
    }

    public void writeField(String string, String string2, String string3, int n) throws IOException {
        this.println("<TR>\n<TD ALIGN=RIGHT NOWRAP>" + string + ":</TD>");
        this.println("<TD><INPUT name=\"" + string2 + "\" value=\"" + this.encode(string3) + "\" size=" + n + "></TD>\n</TR>");
    }

    public void writeField(String string, String string2, Props props, int n) throws IOException {
        this.writeField(string, string2, props.getString(string2), n);
    }

    public void writeHiddenField(String string, String string2) throws IOException {
        this.println("<INPUT type=HIDDEN name=\"" + string + "\" value=\"" + this.encode(string2) + "\">");
    }

    public void writeHiddenField(String string, Props props) throws IOException {
        this.writeHiddenField(string, props.getString(string));
    }

    public void writeLoginFields(String string, String string2) throws IOException {
        this.writeHiddenField("login_user", string);
        this.writeHiddenField("login_hash", String.valueOf(string2.hashCode()));
    }

    public void writeLoginFields(Props props) throws IOException {
        this.writeLoginFields(props.getString("name"), props.getString("password"));
    }

    public void writeMultilineField(String string, String string2, int n, int n2) throws IOException {
        this.writeMultilineField(string, string2, "", n, n2);
    }

    public void writeMultilineField(String string, String string2, String string3, int n, int n2) throws IOException {
        if (n2 < 3) {
            n2 = 3;
        }
        this.println("<TR>\n<TD ALIGN=RIGHT NOWRAP>" + string + ":</TD>");
        this.println("<TD><TEXTAREA name=\"" + string2 + "\" cols=" + n + " rows=" + n2 + ">" + this.encode(string3) + "</TEXTAREA></TD>\n</TR>");
    }

    public void writeMultilineField(String string, String string2, Props props, int n, int n2) throws IOException {
        this.writeMultilineField(string, string2, props.getString(string2), n, n2);
    }

    public void writePassword(String string, String string2, int n) throws IOException {
        this.writePassword(string, string2, "", n);
    }

    public void writePassword(String string, String string2, String string3, int n) throws IOException {
        this.println("<TR>\n<TD ALIGN=RIGHT NOWRAP>" + string + ":</TD>");
        this.println("<TD><INPUT type=password name=\"" + string2 + "\" value=\"" + string3 + "\" size=" + n + "></TD>\n</TR>");
    }

    public void writeProps(Props props) throws IOException {
        Enumeration enumeration = props.enumerateKeys();
        this.println("<TABLE BORDER>");
        this.println("<TR>\n<TH>Key<TH>Value<TH>Class");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.print("<TR><TD>");
            this.print(string);
            this.print("</TD><TD><PRE>");
            this.print(props.getString(string));
            this.print("</PRE></TD><TD>");
            this.print(props.getProperty(string).getClass().getName());
            this.println("</TD></TR>");
        }
        this.println("</TABLE>");
    }

    public void writeResetButton(String string, String string2) throws IOException {
        this.println("<TR>\n<TD ALIGN=RIGHT><INPUT type=reset value=\"" + this.encode(string) + "\"></TD>");
        this.println("<TD>" + string2 + "</TD>\n</TR>");
    }

    public void writeSelectFooter() throws IOException {
        this.println("</SELECT></TD>\n</TR>");
    }

    public void writeSelectHeader(String string, String string2, boolean bl) throws IOException {
        this.println("<TR>\n<TD ALIGN=RIGHT>" + string + ":</TD>");
        if (bl) {
            this.println("<TD><SELECT name=" + string2 + " multiple>");
        } else {
            this.println("<TD><SELECT name=" + string2 + ">");
        }
    }

    public void writeSelectItem(String string, String string2, boolean bl) throws IOException {
        if (bl) {
            this.println("<OPTION value=\"" + string2 + "\" selected>" + string + "</OPTION>");
        } else {
            this.println("<OPTION value=\"" + string2 + "\">" + string + "</OPTION>");
        }
    }

    public void writeSelectItem(String string, String string2, String string3) throws IOException {
        this.writeSelectItem(string, string2, string3.equals(string2));
    }

    public void writeStaticField(String string, String string2) throws IOException {
        this.println("<TR>\n<TD ALIGN=RIGHT>" + string + ":</TD>");
        this.println("<TD>" + string2 + "</TD>\n</TR>");
    }

    public void writeSubmitButton(String string, String string2, String string3) throws IOException {
        this.println("<TR>\n<TD ALIGN=RIGHT><INPUT type=submit name=" + string2 + " value=\"" + string + "\"></TD>");
        this.println("<TD>" + string3 + "</TD>\n</TR>");
    }

    protected String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("&");
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, ++n));
            stringBuffer.append("amp;");
            n2 = n;
            n = string.indexOf("&", n);
        }
        stringBuffer.append(string.substring(n2));
        string = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        n = string.indexOf("\"");
        n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append("&quot;");
            n2 = ++n;
            n = string.indexOf("\"", n);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }
}

